//
// Inclusion of standard header file
//
#include <cmath>
#include <cstddef>
#include <limits>
#include <stdexcept>

//
// Inclusion of local header file
//
#include "get_number_of_figures.hpp"
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of function
    //
    std::size_t
      get_number_of_figures
      (
        int x
      )
      {
        class local
          {
          public:
            local
              (
                int const local_x
              )
              {
                islib_throw_if_with_message ( std::invalid_argument, islib::get_number_of_figures, local_x == 0 );
              }

            ~local
              (
              )
              throw
              (
              )
              {
              }
          }
        a_local ( x );

        if ( x < 0 )
          x = -x;

        std::size_t number_of_figures = 1;

        while ( x > static_cast < int > ( std::pow ( 10.0, static_cast < double > ( number_of_figures ) ) ) )
          ++number_of_figures;

        return number_of_figures;
      }
  }

//
// End of file
//
