//
// Inclusion of standard header file
//
#include <cmath>
#include <limits>
#include <stdexcept>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"
#include "logit.hpp"

namespace islib
  {
    //
    // Definition of function
    //
    double
      logit
      (
        double const x
      )
      {
        class local
          {
          public:
            local
              (
                double const local_x
              )
              {
                islib_throw_if_with_message ( std::invalid_argument, islib::logit, is_less_than ( local_x, 0.0, std::numeric_limits < double >::epsilon () ) || is_greater_than ( local_x, 1.0, std::numeric_limits < double >::epsilon () ) );
              }

            ~local
              (
              )
              throw
              (
              )
              {
              }
          }
          a_local ( x );

        return std::log ( x / ( 1.0 - x ) );
      }
  }

//
// End of file
//
