#ifndef DEFINE_ISLIB_NAME_HOLDER_HPP

#defines DEFINE_ISLIB_NAME_HOLDER_HPP

//
// Inclusion of standard header file
//
#include <string>

namespace islib
  {
    //
    // Definition of class template
    //
    template
      <
        typename Value_Type
      >
      class name_holder
      {
      public:
        //
        // Definition of type
        //
        typedef name_holder this_type;
        typedef std::string string_type;
        typedef Value_Type value_type;

        //
        // Declaration of constructor
        //
        name_holder ();
        name_holder ( value_type const & );
        name_holder ( this_type const & );

        //
        // Declaration of destructor
        //
        ~name_holder () throw ();

        //
        // Declaration of non-static operator
        //
        this_type &operator = ( this_type const & );
        bool operator < ( this_type const & ) const;

        //
        // Declaration of non-static member function
        //
        string_type name () const;
        value_type value () const;
        bool is_null () const;
        void swap ( this_type & ) throw ();

        //
        // Declaration of static member function
        //
        string_type replace_name ( string_type const & );

      private:
        //
        // Definition of non-static data member
        //
        string_type member_name;
        value_type member_value;
        bool null_flag;
      };
  }

#include "name_holder.ipp"

#endif // DEFINE_ISLIB_NAME_HOLDER_HPP

//
// End of file
//
