#ifndef DEFINE_ISLIB_NAME_HOLDER_IPP

#define DEFINE_ISLIB_NAME_HOLDER_IPP

//
// Inclusion of standard header file
//
#include <algorithm>

//
// Inclusion of library header file
//
#include <boost/regex.hpp>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of constructor template
    //
    template
      <
        typename Value_Type
      >
      name_holder < Value_Type >::name_holder
      (
      ):
      null_flag ( true )
      {
      }

    //
    // Definition of constructor template
    //
    template
      <
        typename Value_Type
      >
      name_holder < Value_Type >::name_holder
      (
        value_type const &value
      ):
      member_name ( replace_name ( value.name () ) ),
      member_value ( value ),
      null_flag ( false )
      {
        class local
          {
          public:
            local
              (
                value_type const &local_value
              )
              {
                islib_throw_if_with_message ( std::invalid_argument, islib::name_holder < Value_Type >::name_holder, local_value.is_null () );
              }

            ~local
              (
              )
              throw
              (
              )
              {
              }
          }
        a_local ( value );
      }

    //
    // Definition of constructor template
    //
    template
      <
        typename Value_Type
      >
      name_holder < Value_Type >::name_holder
      (
        this_type const &the_other
      ):
      member_name ( the_other.member_name ),
      member_value ( the_other.member_value ),
      null_flag ( the_other.null_flag )
      {
      }

    //
    // Definition of destructor template
    //
    template
      <
        typename Value_Type
      >
      name_holder < Value_Type >::~name_holder
      (
      )
      throw
      (
      )
      {
      }

    //
    // Definition of non-static operator template
    //
    template
      <
        typename Value_Type
      >
      typename name_holder < Value_Type >::this_type &
      name_holder < Value_Type >::operator =
      (
        this_type const &right_hand_side
      )
      {
        this_type temporary ( right_hand_side );

        this->swap ( temporary );

        return *this;
      }

    //
    // Definition of non-static operator template
    //
    template
      <
        typename Value_Type
      >
      bool
      name_holder < Value_Type >::operator <
      (
        this_type const &right_hand_side
      )
      const
      {
        class local
          {
          public:
            local
              (
                this_type const &local_right_hand_side
              )
              {
                islib_throw_if_with_message ( std::invalid_argument, islib::game01::name_holder < Value_Type >::operator <, local_right_hand_side.is_null () );
              }

            ~local
              (
              )
              throw
              (
              )
              {
              }
          }
        a_local ( right_hand_side );

        islib_throw_if_with_message ( std::logic_error, islib::game01::name_holder < Value_Type >::operator <, this->is_null () );

        return this->value () < right_hand_side.value ();
      }

    //
    // Definition of non-static member function
    //
    template
      <
        typename Value_Type
      >
      typename name_holder < Value_Type >::string_type
      name_holder < Value_Type >::name
      (
      )
      const
      {
        string_type a_name;

        class local
          {
          public:
            local
              (
                string_type const &local_name
              ):
              local_name ( local_name )
              {
              }

            ~local
              (
              )
              throw
              (
              )
              {
                islib_assert_with_message ( value_type::is_valid_name ( this->local_name ), islib::name_holder < Value_Type >::name );
              }

          private:
            string_type const &local_name;
          }
        a_local ( a_name );

        islib_throw_if_with_message ( std::logic_error, islib::name_holder < Value_Type >::get_name, this->is_null () );

        a_name = this->member_name;

        return a_name;
      }

    //
    // Definition of non-static member function
    //
    template
      <
        typename Value_Type
      >
      typename name_holder < Value_Type >::value_type
      name_holder < Value_Type >::value
      (
      )
      const
      {
        value_type a_value;

        class local
          {
          public:
            local
              (
                value_type const &local_value
              ):
              local_value ( local_value )
              {
              }

            ~local
              (
              )
              throw
              (
              )
              {
                islib_assert_with_message ( !this->local_value.is_null (), islib::name_holder < Value_Type >::get_value );
              }

          private:
            value_type const &local_value;
          }
        a_local ( a_value );

        islib_throw_if_with_message ( std::logic_error, islib::name_holder < Value_Type >::get_value, this->is_null () );

        a_value = this->member_value;

        return a_value;
      }

    //
    // Definition of non-static member function
    //
    template
      <
        typename Value_Type
      >
      bool
      name_holder < Value_Type >::is_null
      (
      )
      const
      {
        return null_flag;
      }

    //
    // Definition of non-static member function
    //
    template
      <
        typename Value_Type
      >
      void
      name_holder < Value_Type >::swap
      (
        this_type &the_other
      )
      throw
      (
      )
      {
        this->member_name.swap ( the_other.name );

        this->member_value.swap ( the_other.value );

        std::swap ( this->null_flag, the_other.null_flag );
      }

    //
    // Definition of static static member function
    //
    template
      <
        typename Value_Type
      >
      typename name_holder < Value_Type >::string_type
      name_holder < Value_Type >::replace_name
      (
        string_type const &name
      )
      {
        string_type replaced_name;

        class local
          {
          public:
            local
              (
                string_type const &local_name,
                string_type const &local_replaced_name
              ):
              local_replaced_name ( local_replaced_name )
              {
                islib_throw_if_with_message ( std::invalid_argument, islib::name_holder < String_Type >::replace_name, local_name.emtpy () );
              }

            ~local
              (
              )
              throw
              (
              )
              {
                islib_assert_with_message ( !this->local_replaced_name.empty (), islib::name_holder < String_Type >::replace_name );
              }

          private:
            string_type const &local_replaced_name;
          }
        a_local ( name, replaced_name );

        boost::regex const regex ( " " );
        string_type const format ( "_" );

        replaced_name = boost::regex_replace ( name, regex, format, boost::regex_constants::match_any );

        return replaced_name;
      }
  }

#endif // DEFINE_ISLIB_NAME_HOLDER_IPP

//
// End of file
//
