#ifndef DEFINE_ISLIB_RANDOM_NUMBER_GENERATOR_HPP

#define DEFINE_ISLIB_RANDOM_NUMBER_GENERATOR_HPP

//
// Inclusion of standard header file
//
#include <cstddef>

//
// Inclusion of library header file
//
#include <boost/random.hpp>

namespace islib
  {
    //
    // Definition of class
    //
    class random_number_generator
      {
      public:
        //
        // Definition of type
        //
        typedef random_number_generator this_type;
        typedef boost::mt19937 random_number_generator_engine_type;
        typedef boost::uniform_real <> random_number_generator_distribution_type;
        typedef boost::variate_generator < random_number_generator_engine_type, random_number_generator_distribution_type > random_number_generator_implement_type;
        typedef unsigned int random_number_seed_type;

        //
        // Declaration of constructor
        //
        random_number_generator ( random_number_seed_type, double = 0.0, double = 1.0 );
        random_number_generator ( double = 0.0, double = 1.0 );

        //
        // Declaration of destructor
        //
        ~random_number_generator () throw ();

        //
        // Declaration of method
        //
        double generate () const;

      private:
        //
        // Definition of non-static data member
        //
        random_number_generator_implement_type mutable random_number_generator_implement;

        //
        // Declaration of static data member
        //
        static std::size_t generate_random_number_seed_calling_times;

        //
        // Declaration of static member function
        //
        static random_number_seed_type generate_random_number_seed ();
      };
  }

#endif // DEFINE_ISLIB_RANDOM_NUMBER_GENERATOR_HPP

//
// End of file
//
