//
// Inclusion of system header file
//
#include <signal.h>

//
// Inclusion of local header file
//
#include "islibfunc.hpp"
#include "signal_blocker.hpp"

namespace islib
  {
    //
    // Definition of constructor
    //
    signal_blocker::signal_blocker
      (
      )
      {
        sigset_t signal_set;

        islib_sigfillset_fatal ( &signal_set );

        islib_sigprocmask_fatal ( SIG_BLOCK, &signal_set, 0 );
      }

    //
    // Definition of destructor
    //
    signal_blocker::~signal_blocker
      (
      )
      throw
      (
      )
      {
        sigset_t signal_set;

        islib_sigfillset_fatal ( &signal_set );

        islib_sigprocmask_fatal ( SIG_UNBLOCK, &signal_set, 0 );
      }
  }

//
// End of file
//
