//@module
/*
  Copyright 2011-2014 Marvell Semiconductor, Inc.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

exports.pins = {
	dummy: {type: "Analog" },
	AD1: { type: "Analog" },
	AD2: { type: "Analog" }
};

exports.configure = function() {
	this.dummy.init();
   this.AD1.init();
  this.AD2.init();
   this.supplyVoltage = 3.268;
};

exports.read = function() {
    return {
    AD1: (this.AD1.read()-1/1024)*this.supplyVoltage,
	AD2: (this.AD2.read()-1/1024)*this.supplyVoltage
      };
};

exports.close = function() {
	this.dummy.close();
	this.AD1.close();
	this.AD2.close();
};

exports.metadata = {
	sources: [
		{
			name: "read",
			result: 
				{ type: "Object", name: "result", properties:
					[
						{ type: "Number", name: "AD1" },
						{ type: "Number", name: "AD2" },
					]
				},
		},
	]
};