let Pins = require("pins");
const bdebug = false;

var temp=0;
var counter=0;
var AD1=0;
var AD2=0;
var tAD1=0;
var tAD2=0;
var ttemp = 0;
var cADC1=0;
var cADC2=0;
var ctemp=0;
var bCompletedAD1 = 0;
var bCompletedAD2 = 0;
var bCompletedTemp = 0;
var nEventID =0;
var DIO1=0;
var DIO2=0;
var szCommand = "";
var nADChannel = 1;
const deviceID = K4.deviceID;

const nAnalogMeasureInterval = 30; //ms
const nDataUploadInterval=30000; //ms
const nGetCommandInterval=1000; //ms
const nDisplayInterval=1000; //ms
const nAccumAD1=4;
const nAccumAD2=4;
const nAccumTemp=4;
//const protomode = "MieSAN";
//const xAD1Gain = 1.9948; //-
const protomode = "Basis";
const xAD1Gain = 1.000;
const szVer = "4.1b2";
const xErrorVoltageMax = 3.2; //V
const xErrorVoltageMin = 0.0; //V
const xErrorTempMax = 100;//C
const xErrorTempMin = -35;//C

log("DeiveID: " +deviceID +"\n");

let whiteSkin = new Skin({ fill:"white" });
let normalText = new Style( { font: "30px", color:"black" } );
let smallText = new Style( { font: "20px", color:"black" } ); 
let label0 = new Label({ left:0, right:0, top:-90, bottom:0, string:"ITO Manager Ver. " + szVer, style: normalText });
let labelpin = new Label({ left:0, right:0, top:-50, bottom:0, string:"AD1:52, AD2:51, Vout(LM61BIZ):54 GND:58", style: smallText });
let label1 = new Label({ left:0, right:0, top:-26, bottom:0, string:"---", style: smallText });
let label2 = new Label({ left:0, right:0, top:0, bottom:0, string:"---", style: smallText });
let label3 = new Label({ left:0, right:0, top:24, bottom:0, string:"---", style: smallText });
let labelDevID = new Label({ left:0, right:0, top:90, bottom:0, string:"DeviceID: " + deviceID , style: smallText });

let mainCon = new Container({ 
    left:0, right:0, top:0, bottom:0, skin: whiteSkin
});
mainCon.add(label0);
mainCon.add(labelpin);
mainCon.add(label1);
mainCon.add(label2);
mainCon.add(label3);
mainCon.add(labelDevID);
application.add(mainCon);

// analogpins 37 -> 52, 38->51, 39->54
Pins.invoke("setPinMux", {
    leftVoltage: 3.3, rightVoltage: 3.3,
    leftPins: [3, 3, 0, 3, 0, 0, 0, 2],
    rightPins: [0, 0, 0, 0, 0, 0, 0, 0]
});


				Pins.configure({
						analogSensor1: {
						require: "AD1",
						pins: {
							AD1: { pin: 52 }
                  			}
					},
					analogSensor2: {
						require: "AD2",
						pins: {
							AD2: { pin: 51 }
                  			}
					},
					analogTemp: {
						require: "LM61BIZ",
						pins: {
							temperature1: { pin: 54 }
                 			}
               		},
              		DIO: {
               			require: "DIO",
                			pins: {
                 				DIO1: { pin: 4 },
                  				DIO2: { pin: 6 }
               			}
            		},
               		ground: {
               			pin: 58, type: "Ground"
               			}
					}
					, function(success) {
   						 if (success){
   						 log("Successed to Pin configure\n");
   						//Pins.repeat("/analogTemp/read", 50, value => TemperatureValueChanged(value));
						//Pins.repeat("/analogSensor1/read", 3, value => Analog1ValueChanged(value));
						//Pins.repeat("/analogSensor2/read", 3, value => Analog2ValueChanged(value));
						//Pins.share("ws", {zeroconf: true, name: "analog-temperature"});
						application.invoke(new Message("/AnalogMeasureTimer"));
   						 }else{
   						 
   						  log("Failed to configure\n");
   						  }
					}
				);

        application.invoke(new Message("/UploadTimer"));
        application.invoke(new Message("/GetCommandTimer"));
        application.invoke(new Message("/DisplayTimer"));


//--sub routine --				
function log(messsage) {
if (bdebug==true){
   trace(messsage);
	}
};

function sleep(time) {
		 let d1 = new Date().getTime();
		 let d2 = new Date().getTime();
			 while (d2 < d1 + time) {
  				  d2 = new Date().getTime();
  				 }
 				  return;
};
	
function TemperatureValueChanged(value){
		let xtemp1 = value.temperature1;
		if (xtemp1 < xErrorTempMax && xtemp1 > xErrorTempMin) {
			ttemp = (ttemp * ctemp + xtemp1)/(ctemp+1);
			ctemp=ctemp+1;
		}
		if (ctemp==nAccumTemp){
			temp= ttemp;
			ctemp =0;
			log("temperature:"+temp.toFixed(3) + ' C AD1:'+AD1.toFixed(3)+'V AD2:'+AD2.toFixed(3)+'V\n');
			if ( bCompletedTemp==0){
	 			bCompletedTemp = 1;
	 			application.invoke(new Message("/KinomaDataUpload"));
			 }
		}					
}

function Analog1ValueChanged(value){
	let voltage = value.AD1;
	if (voltage <= xErrorVoltageMax && voltage >= xErrorVoltageMin) {
		tAD1 = (tAD1 * cADC1 +voltage/xAD1Gain)/(cADC1+1);
		cADC1 = cADC1+1;
	}
	if (cADC1==nAccumAD1){
		AD1= tAD1;
		cADC1 = 0;
		if ( bCompletedAD1==0){
	 		bCompletedAD1 = 1;
	 		application.invoke(new Message("/KinomaDataUpload"));
	 }
	}
//	log("AD1:"+AD1.toFixed(3) + 'V AD2:'+AD2.toFixed(3) +'\n');
}
function Analog2ValueChanged(value){
	let voltage = value.AD2;
	if (voltage <= xErrorVoltageMax && voltage >= xErrorVoltageMin) {
		tAD2 = (tAD2 * cADC2 +voltage)/(cADC2+1);
		cADC2 = cADC2+1;
	}
	if (cADC2==nAccumAD2){
		AD2= tAD2;
		cADC2 = 0;
		if ( bCompletedAD2==0){
	 		bCompletedAD2 = 1;
	 		application.invoke(new Message("/KinomaDataUpload"));
	 	}
	}
//	log('AD2:'+AD2.toFixed(3) +'\n');
}

//--handler--
Handler.bind("/AnalogMeasureTimer", {
    onInvoke: function(handler, message){
    log("TimeAnalog \n");
    if (nADChannel==1){
   		Pins.invoke("/analogTemp/read", value => TemperatureValueChanged(value));
		
   	  	Pins.invoke("setPinMux", {
  	 	 leftVoltage: 3.3, rightVoltage: 3.3,
  		  leftPins: [3, 0, 0, 0, 0, 0, 0, 2],
  		  rightPins: [0, 0, 0, 0, 0, 0, 0, 0]
		});
   	}
   	if (nADChannel==2){
   		Pins.invoke("/analogSensor1/read", value => Analog1ValueChanged(value));
   		
   		Pins.invoke("setPinMux", {
  	 	 leftVoltage: 3.3, rightVoltage: 3.3,
  		  leftPins: [0, 0, 0, 3, 0, 0, 0, 2],
  		  rightPins: [0, 0, 0, 0, 0, 0, 0, 0]
		});
   	}
   	if (nADChannel==3){
   		 Pins.invoke("/analogSensor2/read", value => Analog2ValueChanged(value));
   		 
   		 Pins.invoke("setPinMux", {
  	 	 leftVoltage: 3.3, rightVoltage: 3.3,
  		  leftPins: [0, 3, 0, 0, 0, 0, 0, 2],
  		  rightPins: [0, 0, 0, 0, 0, 0, 0, 0]
		});
   	}
   	 nADChannel = nADChannel +1;
     if (nADChannel > 3){
     	nADChannel = 1;
     } 
     counter=counter+1;
   handler.invoke( new Message("/delayAnalog?duration=" +nAnalogMeasureInterval ));
    },
    onComplete: function(handler, message){
     log("Time2 \n");
     //    handler.invoke( new Message("/delay?duration=" +nDataUploadInterval ));
    }
});

Handler.bind("/delayAnalog", {
    onInvoke: function(handler, message){
    	let query = parseQuery( message.query );
		let duration = query.duration;
        handler.wait(duration); 
    },
    onComplete: function(handler, message){
        handler.invoke(new Message("/AnalogMeasureTimer"));
    }
});



Handler.bind("/UploadTimer", {
    onInvoke: function(handler, message){
    handler.invoke(new Message("/KinomaDataUpload"));
     log("Time \n");
   handler.invoke( new Message("/delay?duration=" +nDataUploadInterval ));
    },
    onComplete: function(handler, message){
     log("Time2 \n");   
     //    handler.invoke( new Message("/delay?duration=" +nDataUploadInterval ));
    }
});

Handler.bind("/delay", {
    onInvoke: function(handler, message){
    	let query = parseQuery( message.query );
		let duration = query.duration;
        handler.wait(duration); //will call onComplete after 10 seconds
    },
    onComplete: function(handler, message){
        handler.invoke(new Message("/UploadTimer"));
    }
});

Handler.bind("/GetCommandTimer", {
    onInvoke: function(handler, message){
    handler.invoke(new Message("/KinomaGetCommand"));
     log("GetCommandTimer\n");
   handler.invoke( new Message("/delayCommand?duration=" +nGetCommandInterval ));
    },
    onComplete: function(handler, message){
     log("GetCommandTimer2 \n");   
     //    handler.invoke( new Message("/delay?duration=" +nDataUploadInterval ));
    }
});

Handler.bind("/delayCommand", {
    onInvoke: function(handler, message){
    	let query = parseQuery( message.query );
		let duration = query.duration;
        handler.wait(duration); 
    },
    onComplete: function(handler, message){
        handler.invoke(new Message("/GetCommandTimer"));
    }
});

Handler.bind("/DisplayTimer", {
    onInvoke: function(handler, message){
    label1.string = "Temperature:"+temp.toFixed(1) + ' C AD1:'+AD1.toFixed(3)+' V AD2:'+AD2.toFixed(3)+' V';
     label2.string = "Counter:"+counter;
     label3.string = "DIO1: " + DIO1 + "  DIO2: " + DIO2;
    handler.invoke( new Message("/delayDisplay?duration=" +nDisplayInterval ));
    log("TImeD\n");
    },
    onComplete: function(handler, message){
     log("TimeD2 \n");   
     //     handler.invoke( new Message("/delayCommand?duration=" +nDisplayInterval ));
    }
});

Handler.bind("/delayDisplay", {
    onInvoke: function(handler, message){
    	let query = parseQuery( message.query );
		let duration = query.duration;
        handler.wait(duration); //will call onComplete after 10 seconds
    },
    onComplete: function(handler, message){
        handler.invoke(new Message("/DisplayTimer"));
    }
});


Handler.bind("/KinomaDataUpload", {
			onInvoke: function(handler, message){
			if (bCompletedAD1 == 1 && bCompletedAD2 == 1 && bCompletedTemp == 1){
				var uri = "http://a.yamagata-u.ac.jp/amenity/network/M2M/KinomaDataReciever.aspx?DeviceID="+deviceID;
				uri = uri + "&AI1=" + AD1;
				uri = uri + "&AI2=" + AD2;
				uri = uri + "&AI3=" + temp;
				uri = uri + "&pm=" + protomode;
				uri = uri + "&EventID=" + nEventID;
				handler.invoke( new Message( uri ), Message.TEXT );
				log("uri:" + uri +"\n");
				}
			},	
			onComplete: function(handler, message){
			//szCommand = data
				//application.distribute( "onLabelDisplayCom", "Command: " + message.status + "," + szCommand);
			log("Http:" +  message.status +"\n");
			},	
			onError: function(handler, message){
				let result = { success: false, items: [] };
				log("Http error:" +  result +"\n");
				//application.distribute( "onLabelDisplayCom", "Command: " + result);
			}	
	}
);
	
Handler.bind("/KinomaGetCommand", {
			onInvoke: function(handler, message){
				var uri = "http://a.yamagata-u.ac.jp/amenity/network/M2M/KinomaControlRequest.aspx?DeviceID="+deviceID;
				handler.invoke( new Message( uri ), Message.TEXT );
			},	
			onComplete: function(handler, message,data){
			szCommand = data

				//command analysis
				if (szCommand.match(/on1/)){
					application.invoke(new Message("/KinomaDataUpload"));
					DIO1=1;
					application.invoke(new MessageWithObject("pins:/DIO/turnOn1"));
					sleep( 50 );
					application.invoke(new Message("/KinomaDataUpload"));
				   }
				   if(szCommand.match(/off1/)) {
					application.invoke(new Message("/KinomaDataUpload"));
					DIO1=0;
					application.invoke(new MessageWithObject("pins:/DIO/turnOff1"));
					sleep( 50 );
					application.invoke(new Message("/KinomaDataUpload"));
					}
				   if(szCommand.match(/on2/)){
					DIO2=1;
					application.invoke(new MessageWithObject("pins:/DIO/turnOn2"));
				   }
				   if(szCommand.match(/off2/)) {
					DIO2=0;
					application.invoke(new MessageWithObject("pins:/DIO/turnOff2"));
					}	 
				 log("DO1(4): "+DIO1+"\n");
            	 log("DO2(6): "+DIO2+"\n");
			log("Http-GetCommand: " + message.status + "," + szCommand +"\n");
			},	
			onError: function(handler, message){
				let result = { success: false, items: [] };
				log("Http error:" +  result +"\n");
				//application.distribute( "onLabelDisplayCom", "Command: " + result);
			}	
	}
);
	
