package jp.sourceforge.functional;

import jp.sourceforge.functional.converter.ConverterMaker;
import jp.sourceforge.functional.converter.UnchangeConverter;
import jp.sourceforge.functional.pair.Pair;

public abstract class BinaryClassifier<T1, T2> extends
		UnaryClassifier<Pair<? extends T1, ? extends T2>> {

	public abstract boolean classify(T1 first, T2 second);

	@Override
	public boolean classify(Pair<? extends T1, ? extends T2> pair) {
		return classify(pair.first, pair.second);
	}

	@Override
	public BinaryClassifier<T1, T2> negative() {
		return new BinaryClassifier<T1, T2>() {
			@Override
			public boolean classify(T1 first, T2 second) {
				return !BinaryClassifier.this.classify(first, second);
			}
		};
	}

	public UnaryClassifier<T2> bindFirst(final T1 first) {
		return new UnaryClassifier<T2>() {
			@Override
			public boolean classify(T2 second) {
				return BinaryClassifier.this.classify(first, second);
			}
		};
	}

	public UnaryClassifier<T1> bindSecond(final T2 second) {
		return new UnaryClassifier<T1>() {
			@Override
			public boolean classify(T1 first) {
				return BinaryClassifier.this.classify(first, second);
			}
		};
	}

	public UnaryConverter<T1, ? extends UnaryClassifier<T2>> firstBinder() {
		return new ConverterMaker<T1, T2, Boolean, UnaryClassifier<T2>>() {
			@Override
			public UnaryClassifier<T2> convert(T1 first) {
				return bindFirst(first);
			}
		};
	}

	public UnaryConverter<T2, ? extends UnaryClassifier<T1>> secondBinder() {
		return new ConverterMaker<T2, T1, Boolean, UnaryClassifier<T1>>() {
			@Override
			public UnaryClassifier<T1> convert(T2 second) {
				return bindSecond(second);
			}
		};
	}

	public <S1, S2> BinaryClassifier<S1, S2> arrangeBoth(
			final Converter<? super S1, ? extends T1> first_converter,
			final Converter<? super S2, ? extends T2> second_converter) {
		return new BinaryClassifier<S1, S2>() {
			@Override
			public boolean classify(S1 first, S2 second) {
				return BinaryClassifier.this.classify(first_converter
						.convert(first), second_converter.convert(second));
			}
		};
	}

	public <S> BinaryClassifier<S, T2> arrangeFirst(
			final Converter<? super S, ? extends T1> converter) {
		return arrangeBoth(converter, UnchangeConverter.<T2> getInstance());
	}

	public <S> BinaryClassifier<T1, S> arrangeSecond(
			final Converter<? super S, ? extends T2> converter) {
		return arrangeBoth(UnchangeConverter.<T1> getInstance(), converter);
	}
}
