package jp.sourceforge.functional.converter;

import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.util.ConvertFunctors;

/**
 * {@code Converter<CT, CR>}(の派生クラス)を戻り値とするコンバーター。
 * 
 * @author Fujii Kenichi
 * 
 * @param <T>
 *            引数
 * @param <CT>
 *            戻り値として指定するコンバーターの引数
 * @param <CR>
 *            戻り値として指定するコンバーターの戻り値
 * @param <CONVERTER>
 *            戻り値として指定するコンバーター
 */
public abstract class ConverterMaker<T, CT, CR, CONVERTER extends Converter<? super CT, ? extends CR>>
		extends UnaryConverter<T, CONVERTER> {

	public <R> UnaryConverter<T, ? extends UnaryConverter<CT, R>> arrangeConverterResult(
			final Converter<? super CR, ? extends R> converter) {
		return arrangeResult(ConvertFunctors.<CT, CR, R> arrangeResult()
				.bindSecond(converter));
	}

	public <S> UnaryConverter<T, ? extends UnaryConverter<S, CR>> arrangeConverterArgument(
			final Converter<? super S, ? extends CT> converter) {
		return arrangeResult(ConvertFunctors.<CT, S, CR> arrange().bindSecond(
				converter));
	}
}
