package jp.sourceforge.functional.pair;

import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.pair.Pair.Side;

public class BoundPairMaker<E1, E2, BIND, REMAIN> extends
		UnaryConverter<REMAIN, Pair<E1, E2>> {

	private final Side<E1, E2, BIND, REMAIN> _side;
	private final BIND _bind;

	public BoundPairMaker(Pair.Side<E1, E2, BIND, REMAIN> side, BIND bind) {
		_side = side;
		_bind = bind;
	}

	@Override
	public Pair<E1, E2> convert(REMAIN source) {
		return _side.makePair(_bind, source);
	}
}
