package jp.sourceforge.functional.pair;

public class Pair<E1, E2> {

	private static final PairFirst<?, ?> FIRST_SIDE = new PairFirst<Object, Object>();
	private static final PairSecond<?, ?> SECOND_SIDE = new PairSecond<Object, Object>();

	public final E1 first;
	public final E2 second;

	public Pair(E1 first, E2 second) {
		this.first = first;
		this.second = second;
	}

	public Pair(Pair<? extends E1, ? extends E2> pair) {
		this(pair.first, pair.second);
	}

	public Object getOpposite(Object value) {
		assert first.equals(value) || second.equals(value);
		return first.equals(value) ? second : first;
	}

	public Pair<E1, E2> arrangeFirst(E1 o) {
		return new Pair<E1, E2>(o, second);
	}

	public Pair<E1, E2> arrangeSecond(E2 o) {
		return new Pair<E1, E2>(first, o);
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof Pair<?, ?>) {
			Pair<?, ?> pair = (Pair<?, ?>) o;
			return first.equals(pair.first) && second.equals(pair.second);
		}
		else return false;
	}

	@Override
	public int hashCode() {
		return (null != first ? first.hashCode() : 0) * 31
				+ (null != second ? second.hashCode() : 0);
	}

	public static <E1, E2> Pair<E1, E2> makePair(E1 first, E2 second) {
		return new Pair<E1, E2>(first, second);
	}

	@Override
	public String toString() {
		return getClass().getName() + "[" + first + "," + second + "]";
	}

	public interface Side<E1, E2, T, OPPOSITE> {
		T getElement(Pair<? extends E1, ? extends E2> pair);

		OPPOSITE getOppositeElement(Pair<? extends E1, ? extends E2> pair);

		Pair<E1, E2> makePair(T element, OPPOSITE opposite_element);
	}

	@SuppressWarnings("unchecked")
	public static <E1, E2> PairFirst<E1, E2> firstSide() {
		return (PairFirst<E1, E2>) FIRST_SIDE;
	}

	@SuppressWarnings("unchecked")
	public static <E1, E2> PairSecond<E1, E2> secondSide() {
		return (PairSecond<E1, E2>) SECOND_SIDE;
	}
}
