package jp.sourceforge.functional.pair;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.pair.Pair.Side;

public class PairFunctors {

	public static <E1, E2, T> BinaryConverter<Pair.Side<? super E1, ? super E2, ? extends T, ?>, Pair<? extends E1, ? extends E2>, T> getElement() {
		return new BinaryConverter<Pair.Side<? super E1, ? super E2, ? extends T, ?>, Pair<? extends E1, ? extends E2>, T>() {
			@Override
			public T convert(Side<? super E1, ? super E2, ? extends T, ?> side,
					Pair<? extends E1, ? extends E2> pair) {
				return side.getElement(pair);
			}
		};
	}

	public static <E1, E2, T> BinaryConverter<Pair.Side<? super E1, ? super E2, ?, ? extends T>, Pair<? extends E1, ? extends E2>, T> getOppositeElement() {
		return new BinaryConverter<Pair.Side<? super E1, ? super E2, ?, ? extends T>, Pair<? extends E1, ? extends E2>, T>() {
			@Override
			public T convert(Side<? super E1, ? super E2, ?, ? extends T> side,
					Pair<? extends E1, ? extends E2> pair) {
				return side.getOppositeElement(pair);
			}
		};
	}

	public static <E1> BinaryConverter<E1, Object, E1> getFirst() {
		return new BinaryConverter<E1, Object, E1>() {
			@Override
			public E1 convert(E1 first, Object second) {
				return first;
			}
		};
	}

	public static <E2> BinaryConverter<Object, E2, E2> getSecond() {
		return new BinaryConverter<Object, E2, E2>() {
			@Override
			public E2 convert(Object first, E2 second) {
				return second;
			}
		};
	}

	public static <E1, E2> BinaryConverter<E1, E2, Pair<E1, E2>> make() {
		return new BinaryConverter<E1, E2, Pair<E1, E2>>() {
			@Override
			public Pair<E1, E2> convert(E1 first, E2 second) {
				return Pair.makePair(first, second);
			}
		};
	}

	public static <T> UnaryConverter<T, SamePair<T>> makeSame() {
		return new UnaryConverter<T, SamePair<T>>() {
			@Override
			public SamePair<T> convert(T source) {
				return new SamePair<T>(source, source);
			}
		};
	}
}
