package jp.sourceforge.functional.compare;

import java.util.Comparator;

import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.SameBinaryConverter;

public abstract class FunctionalComparator<T> extends
		SameBinaryConverter<T, Integer> implements Comparator<T> {

	@Override
	public int compare(T o1, T o2) {
		return convert(o1, o2);
	}

	@Override
	public FunctionalComparable<T> bindFirst(T first) {
		return new FunctionalComparable<T>(first, this);
	}

	@Override
	public <S> FunctionalComparator<S> arrangeBoth(
			final Converter<? super S, ? extends T> converter) {
		return new FunctionalComparator<S>() {
			@Override
			public Integer convert(S first, S second) {
				return FunctionalComparator.this.convert(converter
						.convert(first), converter.convert(second));
			}
		};
	}

	@Deprecated
	public static <T> FunctionalComparator<T> fromComparator(
			final Comparator<? super T> comparator) {
		return new WrappingFunctionalComparator<T>(comparator);
	}
}
