package jp.sourceforge.functional.compare;

import jp.sourceforge.functional.UnaryClassifier;

public class Range<T extends Comparable<T>> extends UnaryClassifier<T> {

	private final T _from;
	private final T _to;

	public Range(T from, T to) {
		assert from.compareTo(to) <= 0;
		this._from = from;
		this._to = to;
	}

	@Override
	public boolean classify(T object) {
		return (_from.compareTo(object) <= 0) && (_to.compareTo(object) > 0);
	}

	public T getFrom() {
		return _from;
	}

	public T getTo() {
		return _to;
	}
}
