/**
 * 
 */
package jp.sourceforge.functional.compare;

import java.io.Serializable;
import java.util.Comparator;

public class WrappingFunctionalComparator<T> extends FunctionalComparator<T>
		implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final Comparator<? super T> _comparator;

	public WrappingFunctionalComparator(Comparator<? super T> comparator) {
		_comparator = comparator;
	}

	@Override
	public Integer convert(T first, T second) {
		return _comparator.compare(first, second);
	}

	@Override
	public int compare(T o1, T o2) {
		return _comparator.compare(o1, o2);
	}
}
