package jp.sourceforge.functional.iterable;

import java.util.Iterator;

import jp.sourceforge.functional.Classifier;
import jp.sourceforge.functional.getter.InvalidHolder;
import jp.sourceforge.functional.getter.ValidHolder;
import jp.sourceforge.functional.getter.ValidateGetter;

public class ExtractIterable<E> implements Iterable<E> {

	private final Iterable<? extends E> _iterable;
	private final Classifier<? super E> _extractor;

	public ExtractIterable(Iterable<? extends E> iterable,
			Classifier<? super E> extractor) {
		_iterable = iterable;
		_extractor = extractor;
	}

	@Override
	public UnremovableIterator<E> iterator() {
		final Iterator<? extends E> _iterator = _iterable.iterator();
		return new PrecedeIterator<E>() {
			@Override
			protected ValidateGetter<? extends E> getNextHolder() {
				while (_iterator.hasNext()) {
					E next = _iterator.next();
					if (_extractor.classify(next)) return new ValidHolder<E>(
							next);
				}
				return InvalidHolder.getInstance();
			}
		};
	}
}
