package jp.sourceforge.functional.iterable;

import java.util.NoSuchElementException;

import jp.sourceforge.functional.getter.ValidateGetter;

public abstract class PrecedeIterator<E> extends UnremovableIterator<E> {

	private ValidateGetter<? extends E> _next;

	public PrecedeIterator() {
		_next = getNextHolder();
	}

	protected abstract ValidateGetter<? extends E> getNextHolder();

	@Override
	public boolean hasNext() {
		return _next.validity();
	}

	@Override
	public E next() {
		try {
			E result = _next.get();
			_next = getNextHolder();
			return result;
		} catch (IllegalStateException e) {
			throw new NoSuchElementException();
		}
	}
}
