package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryVisitor;
import jp.sourceforge.functional.UnaryVisitor;
import jp.sourceforge.functional.Visitor;

public class VisitFunctors {

	public static <T> BinaryVisitor<Visitor<? super T>, T> visit() {
		return new BinaryVisitor<Visitor<? super T>, T>() {
			@Override
			public void visit(Visitor<? super T> visitor, T object) {
				visitor.visit(object);
			}
		};
	}

	public static <T> UnaryVisitor<Runnable> run() {
		return new UnaryVisitor<Runnable>() {
			@Override
			public void visit(Runnable runnable) {
				runnable.run();
			}
		};
	}
}
