package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryVisitor;
import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.NullaryVisitor;
import jp.sourceforge.functional.UnaryVisitor;
import jp.sourceforge.functional.Visitor;
import jp.sourceforge.functional.pair.BoundPairMaker;
import jp.sourceforge.functional.pair.Pair;

public class VisitUtil {

	public static <T> NullaryVisitor bind(final Visitor<? super T> visitor,
			final T bind) {
		return new NullaryVisitor() {
			@Override
			public void run() {
				visitor.visit(bind);
			}
		};
	}

	public static <T1, T2> UnaryVisitor<T2> bindFirst(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor, T1 first) {
		return arrange(visitor, PairFunctors.<T1, T2> make().bindFirst(first));
	}

	public static <T1, T2> UnaryVisitor<T1> bindSecond(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor, T2 second) {
		return arrange(visitor, PairFunctors.<T1, T2> make().bindSecond(second));
	}

	public static <T1, T2> NullaryVisitor bindBoth(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor,
			T1 first, T2 second) {
		return bind(visitor, Pair.<T1, T2> makePair(first, second));
	}

	public static <E1, E2, BIND, REMAIN> UnaryVisitor<REMAIN> bindSide(
			Visitor<? super Pair<? extends E1, ? extends E2>> visitor,
			Pair.Side<E1, E2, BIND, REMAIN> side, BIND bind) {
		return arrange(visitor, new BoundPairMaker<E1, E2, BIND, REMAIN>(side,
				bind));
	}

	public static <S, T> UnaryVisitor<S> arrange(
			final Visitor<? super T> visitor,
			final Converter<? super S, ? extends T> converter) {
		return new UnaryVisitor<S>() {
			@Override
			public void visit(S object) {
				visitor.visit(converter.convert(object));
			}
		};
	}

	public static <S1, S2, T> BinaryVisitor<S1, S2> arrangeToBinary(
			final Visitor<? super T> visitor,
			final Converter<? super Pair<? extends S1, ? extends S2>, ? extends T> pair_converter) {
		return new BinaryVisitor<S1, S2>() {
			@Override
			public void visit(S1 first, S2 second) {
				visitor.visit(pair_converter.convert(Pair.makePair(first, second)));
			}
		};
	}

	public static <S1, S2, T1, T2> BinaryVisitor<S1, S2> arrangeBoth(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor,
			Converter<? super S1, ? extends T1> first_converter,
			Converter<? super S2, ? extends T2> second_converter) {
		return arrangeToBinary(visitor, PairFunctors.<T1, T2> make()
				.arrangeBoth(first_converter, second_converter));
	}

	public static <S1, T1, T2> BinaryVisitor<S1, T2> arrangeFirst(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor,
			Converter<? super S1, ? extends T1> first_converter) {
		return arrangeToBinary(visitor, PairFunctors.<T1, T2> make()
				.arrangeFirst(first_converter));
	}

	public static <S2, T1, T2> BinaryVisitor<T1, S2> arrangeSecond(
			Visitor<? super Pair<? extends T1, ? extends T2>> visitor,
			Converter<? super S2, ? extends T2> second_converter) {
		return arrangeToBinary(visitor, PairFunctors.<T1, T2> make()
				.arrangeSecond(second_converter));
	}

	public static <T> UnaryVisitor<T> makeVisitor(
			final Visitor<? super T> visitor) {
		return new UnaryVisitor<T>() {
			@Override
			public void visit(T element) {
				visitor.visit(element);
			}
		};
	}

	public static <T> UnaryVisitor<T> makeVisitor(
			final Converter<? super T, ? extends Void> converter) {
		return new UnaryVisitor<T>() {
			@Override
			public void visit(T element) {
				converter.convert(element);
			}
		};
	}

	public static <T1, T2> BinaryVisitor<T1, T2> makeBinaryVisitor(
			final Visitor<? super Pair<? extends T1, ? extends T2>> visitor) {
		return new BinaryVisitor<T1, T2>() {
			@Override
			public void visit(Pair<? extends T1, ? extends T2> pair) {
				visitor.visit(pair);
			}

			@Override
			public void visit(T1 first, T2 second) {
				visitor.visit(Pair.makePair(first, second));
			}
		};
	}

	public static <T1, T2> BinaryVisitor<T1, T2> makeBinaryVisitor(
			final Converter<? super Pair<? extends T1, ? extends T2>, ? extends Void> converter) {
		return new BinaryVisitor<T1, T2>() {
			@Override
			public void visit(Pair<? extends T1, ? extends T2> pair) {
				converter.convert(pair);
			}

			@Override
			public void visit(T1 first, T2 second) {
				converter.convert(Pair.makePair(first, second));
			}
		};
	}
}
