package jp.sourceforge.functional.visit;

import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.Visitor;

/**
 * <p>
 * 値を返す<code>Visitor</code>。
 * </p>
 * <p>
 * このような（「問い合わせ」と「更新」を同時に行うような）実装は”なるべく”すべきではありませんが、そうした方が都合の良いこともあるでしょう。<BR>
 * そういった場合は、「状態を変更している」と言うことが解りやすくなるよう、このクラスを実装することを推奨します。
 * </p>
 * 
 * 
 * @author Fujii Kenichi
 * 
 * @param <T>
 * @param <R>
 */
public abstract class ReportableVisitor<T, R> extends UnaryConverter<T, R>
		implements Visitor<T> {

	@Override
	public void visit(T element) {
		convert(element);
	}

}
