/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.PersistenceManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoInterceptor
extends JdoAccessor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        block7: {
            PersistenceManager pm;
            block6: {
                boolean existingTransaction = false;
                pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
                if (TransactionSynchronizationManager.hasResource((Object)this.getPersistenceManagerFactory())) {
                    this.logger.debug((Object)"Found thread-bound PersistenceManager for JDO interceptor");
                    existingTransaction = true;
                } else {
                    this.logger.debug((Object)"Using new PersistenceManager for JDO interceptor");
                    TransactionSynchronizationManager.bindResource((Object)this.getPersistenceManagerFactory(), (Object)((Object)new PersistenceManagerHolder(pm)));
                }
                try {
                    Object retVal = methodInvocation.proceed();
                    this.flushIfNecessary(pm, existingTransaction);
                    object = retVal;
                    Object var7_6 = null;
                    if (!existingTransaction) break block6;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (existingTransaction) {
                        this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after interceptor");
                    } else {
                        TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory());
                        PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
                    }
                    throw throwable;
                }
                this.logger.debug((Object)"Not closing pre-bound JDO PersistenceManager after interceptor");
                break block7;
            }
            TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory());
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
        }
        return object;
    }
}

