/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.StringUtils;

public class BeanWrapperImpl
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$BeanWrapperImpl == null ? (class$org$springframework$beans$BeanWrapperImpl = BeanWrapperImpl.class$("org.springframework.beans.BeanWrapperImpl")) : class$org$springframework$beans$BeanWrapperImpl));
    private static final Map defaultEditors = new HashMap();
    private Object object;
    private String nestedPath = "";
    private Map nestedBeanWrappers;
    private Map customEditors;
    private CachedIntrospectionResults cachedIntrospectionResults;
    static /* synthetic */ Class class$org$springframework$beans$BeanWrapperImpl;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$ByteArrayPropertyEditor;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$ClassEditor;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$FileEditor;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$InputStreamEditor;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$LocaleEditor;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$PropertiesEditor;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$StringArrayPropertyEditor;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$springframework$beans$propertyeditors$URLEditor;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;

    public BeanWrapperImpl() {
    }

    public BeanWrapperImpl(Object object) throws BeansException {
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Object object, String nestedPath) throws BeansException {
        this.setWrappedInstance(object);
        this.nestedPath = nestedPath;
    }

    public BeanWrapperImpl(Class clazz) throws BeansException {
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public void setWrappedInstance(Object object) throws BeansException {
        if (object == null) {
            throw new FatalBeanException("Cannot set BeanWrapperImpl target to a null object");
        }
        this.object = object;
        this.nestedBeanWrappers = null;
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(object.getClass())) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(object.getClass());
        }
    }

    public Class getWrappedClass() {
        return this.object.getClass();
    }

    public Object getWrappedInstance() {
        return this.object;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (propertyPath != null) {
            List bws = this.getBeanWrappersForPropertyPath(propertyPath);
            Iterator it = bws.iterator();
            while (it.hasNext()) {
                BeanWrapperImpl bw = (BeanWrapperImpl)it.next();
                bw.doRegisterCustomEditor(requiredType, this.getFinalPath(propertyPath), propertyEditor);
            }
        } else {
            this.doRegisterCustomEditor(requiredType, propertyPath, propertyEditor);
        }
    }

    private void doRegisterCustomEditor(Class requiredType, String propertyName, PropertyEditor propertyEditor) {
        if (this.customEditors == null) {
            this.customEditors = new HashMap();
        }
        if (propertyName != null) {
            this.customEditors.put(propertyName, propertyEditor);
        } else {
            if (requiredType == null) {
                throw new IllegalArgumentException("No propertyName and no requiredType specified");
            }
            this.customEditors.put(requiredType, propertyEditor);
        }
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (propertyPath != null) {
            BeanWrapperImpl bw = this.getBeanWrapperForPropertyPath(propertyPath);
            return bw.doFindCustomEditor(requiredType, this.getFinalPath(propertyPath));
        }
        return this.doFindCustomEditor(requiredType, propertyPath);
    }

    private PropertyEditor doFindCustomEditor(Class requiredType, String propertyName) {
        if (this.customEditors == null) {
            return null;
        }
        if (propertyName != null) {
            try {
                int keyIndex;
                PropertyEditor editor = (PropertyEditor)this.customEditors.get(propertyName);
                if (editor == null && (keyIndex = propertyName.indexOf(91)) != -1) {
                    editor = (PropertyEditor)this.customEditors.get(propertyName.substring(0, keyIndex));
                }
                if (editor != null) {
                    return editor;
                }
                if (requiredType == null) {
                    requiredType = this.getPropertyDescriptor(propertyName).getPropertyType();
                }
            }
            catch (BeansException ex) {
                requiredType = this.getPropertyValue(propertyName).getClass();
            }
        }
        return (PropertyEditor)this.customEditors.get(requiredType);
    }

    private boolean isNestedProperty(String path) {
        return path.indexOf(".") != -1;
    }

    private String getFinalPath(String nestedPath) {
        return nestedPath.substring(nestedPath.lastIndexOf(".") + 1);
    }

    private BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) {
        int pos = propertyPath.indexOf(".");
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    private List getBeanWrappersForPropertyPath(String propertyPath) {
        ArrayList<BeanWrapperImpl> beanWrappers = new ArrayList<BeanWrapperImpl>();
        int pos = propertyPath.indexOf(".");
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            if (nestedProperty.indexOf(91) == -1) {
                Class<?> propertyType = this.getPropertyDescriptor(nestedProperty).getPropertyType();
                if (propertyType.isArray()) {
                    Object[] array = (Object[])this.getPropertyValue(nestedProperty);
                    for (int i = 0; i < array.length; ++i) {
                        beanWrappers.addAll(this.getBeanWrappersForNestedProperty(propertyPath, nestedProperty + "[" + i + "]", nestedPath));
                    }
                    return beanWrappers;
                }
                if ((class$java$util$List == null ? (class$java$util$List = BeanWrapperImpl.class$("java.util.List")) : class$java$util$List).isAssignableFrom(propertyType)) {
                    List list = (List)this.getPropertyValue(nestedProperty);
                    for (int i = 0; i < list.size(); ++i) {
                        beanWrappers.addAll(this.getBeanWrappersForNestedProperty(propertyPath, nestedProperty + "[" + i + "]", nestedPath));
                    }
                    return beanWrappers;
                }
                if ((class$java$util$Map == null ? (class$java$util$Map = BeanWrapperImpl.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(propertyType)) {
                    Map map = (Map)this.getPropertyValue(nestedProperty);
                    Iterator it = map.keySet().iterator();
                    while (it.hasNext()) {
                        beanWrappers.addAll(this.getBeanWrappersForNestedProperty(propertyPath, nestedProperty + "[" + it.next() + "]", nestedPath));
                    }
                    return beanWrappers;
                }
            }
            beanWrappers.addAll(this.getBeanWrappersForNestedProperty(propertyPath, nestedProperty, nestedPath));
            return beanWrappers;
        }
        beanWrappers.add(this);
        return beanWrappers;
    }

    private List getBeanWrappersForNestedProperty(String propertyPath, String nestedProperty, String nestedPath) {
        logger.debug((Object)("Navigating to nested property '" + nestedProperty + "' of property path '" + propertyPath + "'"));
        BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
        return nestedBw.getBeanWrappersForPropertyPath(nestedPath);
    }

    private BeanWrapperImpl getNestedBeanWrapper(String nestedProperty) {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        String[] tokens = this.getPropertyNameTokens(nestedProperty);
        Object propertyValue = this.getPropertyValue(tokens[0], tokens[1], tokens[2]);
        String canonicalName = tokens[0];
        if (propertyValue == null) {
            throw new NullValueInNestedPathException(this.getWrappedClass(), canonicalName);
        }
        BeanWrapperImpl nestedBw = (BeanWrapperImpl)this.nestedBeanWrappers.get(canonicalName);
        if (nestedBw == null) {
            logger.debug((Object)("Creating new nested BeanWrapper for property '" + canonicalName + "'"));
            nestedBw = new BeanWrapperImpl(propertyValue, this.nestedPath + canonicalName + ".");
            if (this.customEditors != null) {
                Iterator it = this.customEditors.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (!(key instanceof Class)) continue;
                    Class requiredType = (Class)key;
                    PropertyEditor propertyEditor = (PropertyEditor)this.customEditors.get(key);
                    nestedBw.registerCustomEditor(requiredType, null, propertyEditor);
                }
            }
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else {
            logger.debug((Object)("Using cached nested BeanWrapper for property '" + canonicalName + "'"));
        }
        return nestedBw;
    }

    private String[] getPropertyNameTokens(String propertyName) {
        String actualName = propertyName;
        String key = null;
        int keyStart = propertyName.indexOf(91);
        if (keyStart != -1 && propertyName.endsWith("]")) {
            actualName = propertyName.substring(0, keyStart);
            key = propertyName.substring(keyStart + 1, propertyName.length() - 1);
            if (key.startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            } else if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
        }
        String canonicalName = actualName;
        if (key != null) {
            canonicalName = canonicalName + "[" + key + "]";
        }
        return new String[]{canonicalName, actualName, key};
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        if (this.isNestedProperty(propertyName)) {
            BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
            return nestedBw.getPropertyValue(this.getFinalPath(propertyName));
        }
        String[] tokens = this.getPropertyNameTokens(propertyName);
        return this.getPropertyValue(tokens[0], tokens[1], tokens[2]);
    }

    private Object getPropertyValue(String propertyName, String actualName, String key) {
        PropertyDescriptor pd = this.getPropertyDescriptor(actualName);
        Method readMethod = pd.getReadMethod();
        if (readMethod == null) {
            throw new FatalBeanException("Cannot get property '" + actualName + "': not readable", null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("About to invoke read method [" + readMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
        }
        try {
            Object value = readMethod.invoke(this.object, null);
            if (key != null) {
                if (value == null) {
                    throw new FatalBeanException("Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
                }
                if (value.getClass().isArray()) {
                    return Array.get(value, Integer.parseInt(key));
                }
                if (value instanceof List) {
                    List list = (List)value;
                    return list.get(Integer.parseInt(key));
                }
                if (value instanceof Set) {
                    Set set = (Set)value;
                    int index = Integer.parseInt(key);
                    Iterator it = set.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Object elem = it.next();
                        if (i == index) {
                            return elem;
                        }
                        ++i;
                    }
                    throw new FatalBeanException("Cannot get element with index " + index + " from Set of size " + set.size() + ", accessed using property path '" + propertyName + "'");
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    return map.get(key);
                }
                throw new FatalBeanException("Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + value + "]");
            }
            return value;
        }
        catch (InvocationTargetException ex) {
            throw new FatalBeanException("Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new FatalBeanException("Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new FatalBeanException("Invalid index in property path '" + propertyName + "'");
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        if (this.isNestedProperty(propertyName)) {
            try {
                BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
                nestedBw.setPropertyValue(new PropertyValue(this.getFinalPath(propertyName), value));
                return;
            }
            catch (NullValueInNestedPathException ex) {
                throw ex;
            }
            catch (FatalBeanException ex) {
                throw new NotWritablePropertyException(propertyName, this.getWrappedClass(), ex);
            }
        }
        String[] tokens = this.getPropertyNameTokens(propertyName);
        this.setPropertyValue(tokens[0], tokens[1], tokens[2], value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyValue(String propertyName, String actualName, String key, Object value) throws BeansException {
        if (key != null) {
            Object propValue = this.getPropertyValue(actualName);
            if (propValue == null) {
                throw new FatalBeanException("Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
            }
            if (propValue.getClass().isArray()) {
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, propValue.getClass().getComponentType());
                Array.set(propValue, Integer.parseInt(key), newValue);
                return;
            } else if (propValue instanceof List) {
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, null);
                List list = (List)propValue;
                int index = Integer.parseInt(key);
                if (index < list.size()) {
                    list.set(index, newValue);
                    return;
                } else {
                    if (index < list.size()) return;
                    for (int i = list.size(); i < index; ++i) {
                        try {
                            list.add(null);
                            continue;
                        }
                        catch (NullPointerException ex) {
                            throw new FatalBeanException("Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                        }
                    }
                    list.add(newValue);
                }
                return;
            } else {
                if (!(propValue instanceof Map)) throw new FatalBeanException("Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + value + "]");
                Object newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, null);
                Map map = (Map)propValue;
                map.put(key, newValue);
            }
            return;
        }
        if (!this.isWritableProperty(propertyName)) {
            throw new NotWritablePropertyException(propertyName, this.getWrappedClass());
        }
        PropertyDescriptor pd = this.getPropertyDescriptor(propertyName);
        Method writeMethod = pd.getWriteMethod();
        Object newValue = null;
        try {
            newValue = this.doTypeConversionIfNecessary(propertyName, propertyName, null, value, pd.getPropertyType());
            if (pd.getPropertyType().isPrimitive() && (newValue == null || "".equals(newValue))) {
                throw new IllegalArgumentException("Invalid value [" + value + "] for property '" + pd.getName() + "' of primitive type [" + pd.getPropertyType() + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to invoke write method [" + writeMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
            }
            writeMethod.invoke(this.object, newValue);
            if (!logger.isDebugEnabled()) return;
            String msg = "Invoked write method [" + writeMethod + "] with value ";
            if (newValue == null || BeanUtils.isSimpleProperty(pd.getPropertyType())) {
                logger.debug((Object)(msg + "[" + newValue + "]"));
                return;
            } else {
                logger.debug((Object)(msg + "of type [" + pd.getPropertyType().getName() + "]"));
            }
            return;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.object, this.nestedPath + propertyName, null, newValue);
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(ex.getTargetException(), propertyChangeEvent);
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new FatalBeanException("Illegal attempt to set property [" + value + "] threw exception", ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.object, this.nestedPath + propertyName, null, newValue);
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), (Throwable)ex);
        }
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues(new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown) throws BeansException {
        ArrayList<PropertyAccessException> propertyAccessExceptions = new ArrayList<PropertyAccessException>();
        PropertyValue[] pvs = propertyValues.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            try {
                this.setPropertyValue(pvs[i]);
                continue;
            }
            catch (NotWritablePropertyException ex) {
                if (ignoreUnknown) continue;
                throw ex;
            }
            catch (TypeMismatchException ex) {
                propertyAccessExceptions.add(ex);
                continue;
            }
            catch (MethodInvocationException ex) {
                propertyAccessExceptions.add(ex);
            }
        }
        if (!propertyAccessExceptions.isEmpty()) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyAccessExceptionsException(this, paeArray);
        }
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) throws BeansException {
        return new PropertyChangeEvent(this.object != null ? this.object : "constructor", propertyName != null ? this.nestedPath + propertyName : null, oldValue, newValue);
    }

    public Object doTypeConversionIfNecessary(Object newValue, Class requiredType) throws BeansException {
        return this.doTypeConversionIfNecessary(null, null, null, newValue, requiredType);
    }

    protected Object doTypeConversionIfNecessary(String propertyName, String fullPropertyName, Object oldValue, Object newValue, Class requiredType) throws BeansException {
        if (newValue != null) {
            PropertyEditor pe;
            if (requiredType != null && requiredType.isArray()) {
                Class<?> componentType = requiredType.getComponentType();
                if (newValue instanceof List) {
                    List list = (List)newValue;
                    Object result = Array.newInstance(componentType, list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, list.get(i), componentType);
                        Array.set(result, i, value);
                    }
                    return result;
                }
                if (newValue instanceof Object[]) {
                    Object[] array = (Object[])newValue;
                    Object result = Array.newInstance(componentType, array.length);
                    for (int i = 0; i < array.length; ++i) {
                        Object value = this.doTypeConversionIfNecessary(propertyName, propertyName + "[" + i + "]", null, array[i], componentType);
                        Array.set(result, i, value);
                    }
                    return result;
                }
            }
            if ((pe = this.findCustomEditor(requiredType, fullPropertyName)) != null || requiredType != null && !requiredType.isAssignableFrom(newValue.getClass())) {
                if (newValue instanceof String[]) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Converting String array to comma-delimited String [" + newValue + "]"));
                    }
                    newValue = StringUtils.arrayToCommaDelimitedString((String[])newValue);
                }
                if (newValue instanceof String) {
                    if (pe == null && (pe = this.findDefaultEditor(requiredType)) == null) {
                        pe = PropertyEditorManager.findEditor(requiredType);
                    }
                    if (pe != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + "]"));
                        }
                        try {
                            pe.setAsText((String)newValue);
                            newValue = pe.getValue();
                        }
                        catch (IllegalArgumentException ex) {
                            throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                        }
                    }
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType);
                }
                if (pe != null) {
                    try {
                        pe.setValue(newValue);
                        newValue = pe.getValue();
                    }
                    catch (IllegalArgumentException ex) {
                        throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                    }
                }
            }
            if (requiredType != null && requiredType.isArray() && !newValue.getClass().isArray()) {
                Class<?> componentType = requiredType.getComponentType();
                Object result = Array.newInstance(componentType, 1);
                Object val = this.doTypeConversionIfNecessary(propertyName, propertyName + "[0]", null, newValue, componentType);
                Array.set(result, 0, val);
                return result;
            }
        }
        return newValue;
    }

    private PropertyEditor findDefaultEditor(Class type) {
        Class editorClass = (Class)defaultEditors.get(type);
        if (editorClass != null) {
            return (PropertyEditor)BeanUtils.instantiateClass(editorClass);
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        if (propertyName == null) {
            throw new FatalBeanException("Can't find property descriptor for null property");
        }
        if (this.isNestedProperty(propertyName)) {
            BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
            return nestedBw.getPropertyDescriptor(this.getFinalPath(propertyName));
        }
        return this.cachedIntrospectionResults.getPropertyDescriptor(propertyName);
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        Class<?> type;
        block2: {
            type = null;
            try {
                type = this.getPropertyDescriptor(propertyName).getPropertyType();
            }
            catch (BeansException ex) {
                Object value = this.getPropertyValue(propertyName);
                if (value == null) break block2;
                type = value.getClass();
            }
        }
        return type;
    }

    public boolean isReadableProperty(String propertyName) {
        if (propertyName == null) {
            throw new FatalBeanException("Can't find readability status for null property");
        }
        try {
            return this.getPropertyDescriptor(propertyName).getReadMethod() != null;
        }
        catch (BeansException ex) {
            return false;
        }
    }

    public boolean isWritableProperty(String propertyName) {
        if (propertyName == null) {
            throw new FatalBeanException("Can't find writability status for null property");
        }
        try {
            return this.getPropertyDescriptor(propertyName).getWriteMethod() != null;
        }
        catch (BeansException ex) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("BeanWrapperImpl: wrapping class [" + this.getWrappedInstance().getClass().getName() + "]; ");
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            if (pds != null) {
                for (int i = 0; i < pds.length; ++i) {
                    Object val = this.getPropertyValue(pds[i].getName());
                    String valStr = val != null ? val.toString() : "null";
                    sb.append(pds[i].getName() + "={" + valStr + "}");
                }
            }
        }
        catch (Exception ex) {
            sb.append("exception encountered: " + ex);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultEditors.put(array$B == null ? (array$B = BeanWrapperImpl.class$("[B")) : array$B, class$org$springframework$beans$propertyeditors$ByteArrayPropertyEditor == null ? (class$org$springframework$beans$propertyeditors$ByteArrayPropertyEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.ByteArrayPropertyEditor")) : class$org$springframework$beans$propertyeditors$ByteArrayPropertyEditor);
        defaultEditors.put(class$java$lang$Class == null ? (class$java$lang$Class = BeanWrapperImpl.class$("java.lang.Class")) : class$java$lang$Class, class$org$springframework$beans$propertyeditors$ClassEditor == null ? (class$org$springframework$beans$propertyeditors$ClassEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.ClassEditor")) : class$org$springframework$beans$propertyeditors$ClassEditor);
        defaultEditors.put(class$java$io$File == null ? (class$java$io$File = BeanWrapperImpl.class$("java.io.File")) : class$java$io$File, class$org$springframework$beans$propertyeditors$FileEditor == null ? (class$org$springframework$beans$propertyeditors$FileEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.FileEditor")) : class$org$springframework$beans$propertyeditors$FileEditor);
        defaultEditors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = BeanWrapperImpl.class$("java.io.InputStream")) : class$java$io$InputStream, class$org$springframework$beans$propertyeditors$InputStreamEditor == null ? (class$org$springframework$beans$propertyeditors$InputStreamEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.InputStreamEditor")) : class$org$springframework$beans$propertyeditors$InputStreamEditor);
        defaultEditors.put(class$java$util$Locale == null ? (class$java$util$Locale = BeanWrapperImpl.class$("java.util.Locale")) : class$java$util$Locale, class$org$springframework$beans$propertyeditors$LocaleEditor == null ? (class$org$springframework$beans$propertyeditors$LocaleEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.LocaleEditor")) : class$org$springframework$beans$propertyeditors$LocaleEditor);
        defaultEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = BeanWrapperImpl.class$("java.util.Properties")) : class$java$util$Properties, class$org$springframework$beans$propertyeditors$PropertiesEditor == null ? (class$org$springframework$beans$propertyeditors$PropertiesEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.PropertiesEditor")) : class$org$springframework$beans$propertyeditors$PropertiesEditor);
        defaultEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanWrapperImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$org$springframework$beans$propertyeditors$StringArrayPropertyEditor == null ? (class$org$springframework$beans$propertyeditors$StringArrayPropertyEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.StringArrayPropertyEditor")) : class$org$springframework$beans$propertyeditors$StringArrayPropertyEditor);
        defaultEditors.put(class$java$net$URL == null ? (class$java$net$URL = BeanWrapperImpl.class$("java.net.URL")) : class$java$net$URL, class$org$springframework$beans$propertyeditors$URLEditor == null ? (class$org$springframework$beans$propertyeditors$URLEditor = BeanWrapperImpl.class$("org.springframework.beans.propertyeditors.URLEditor")) : class$org$springframework$beans$propertyeditors$URLEditor);
    }
}

