/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EJBInvokerJob
implements Job {
    public static final String EJB_JNDI_NAME_KEY = "ejb";
    public static final String EJB_METHOD_KEY = "method";
    public static final String EJB_ARGS_KEY = "args";
    static /* synthetic */ Class class$javax$ejb$EJBHome;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail detail = context.getJobDetail();
        JobDataMap dataMap = detail.getJobDataMap();
        String ejb = dataMap.getString(EJB_JNDI_NAME_KEY);
        String method = dataMap.getString(EJB_METHOD_KEY);
        Object[] arguments = (Object[])dataMap.get(EJB_ARGS_KEY);
        if (ejb == null) {
            throw new JobExecutionException();
        }
        InitialContext jndiContext = null;
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException ne) {
            throw new JobExecutionException(ne);
        }
        Object value = null;
        try {
            value = jndiContext.lookup(ejb);
        }
        catch (NamingException ne) {
            throw new JobExecutionException(ne);
        }
        EJBHome ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)value, (Class)(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EJBInvokerJob.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome));
        EJBMetaData metaData = null;
        try {
            metaData = ejbHome.getEJBMetaData();
        }
        catch (RemoteException re) {
            throw new JobExecutionException(re);
        }
        Class homeClass = metaData.getHomeInterfaceClass();
        Class remoteClass = metaData.getRemoteInterfaceClass();
        ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)ejbHome, (Class)homeClass);
        Method methodCreate = null;
        try {
            methodCreate = homeClass.getDeclaredMethod("create", null);
        }
        catch (NoSuchMethodException nsme) {
            throw new JobExecutionException(nsme);
        }
        EJBObject remoteObj = null;
        try {
            remoteObj = (EJBObject)methodCreate.invoke((Object)ejbHome, null);
        }
        catch (IllegalAccessException iae) {
            throw new JobExecutionException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new JobExecutionException(ite);
        }
        Method methodExecute = null;
        try {
            Class[] argTypes = new Class[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                argTypes[i] = arguments[i].getClass();
                ++i;
            }
            methodExecute = remoteClass.getDeclaredMethod(method, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new JobExecutionException(nsme);
        }
        try {
            methodExecute.invoke((Object)remoteObj, arguments);
        }
        catch (IllegalAccessException iae) {
            throw new JobExecutionException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new JobExecutionException(ite);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

