/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.Key;
import org.exolab.castor.xml.schema.KeyRef;
import org.exolab.castor.xml.schema.Unique;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.FieldOrSelectorUnmarshaller;

public class IdentityConstraintUnmarshaller
extends ComponentReader {
    private ComponentReader _unmarshaller;
    private int _depth = 0;
    private IdentityConstraint _identityConstraint = null;
    private boolean _foundAnnotation = false;
    private boolean _foundSelector = false;
    private boolean _foundField = false;
    private String _elementName = null;

    public IdentityConstraintUnmarshaller(String string, AttributeSet attributeSet) throws XMLException {
        this._elementName = string;
        String string2 = attributeSet.getValue("name");
        if (string2 == null) {
            this.error("The 'name' attribute for an identity-constraint must exist.");
        }
        String string3 = attributeSet.getValue("id");
        if ("keyref".equals(string)) {
            String string4 = attributeSet.getValue("refer");
            if (string4 == null) {
                this.error("The 'refer' attribute for keyref must exist.");
            }
            this._identityConstraint = new KeyRef(string2, string4);
        } else {
            this._identityConstraint = "unique".equals(string) ? new Unique(string2) : new Key(string2);
        }
    }

    public String elementName() {
        return this._elementName;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this._identityConstraint;
    }

    public Object getObject() {
        return this.getIdentityConstraint();
    }

    public void finish() throws XMLException {
        if (!this._foundSelector) {
            this.error("Invalid " + this._elementName + "; missing 'selector'.");
        } else if (!this._foundField) {
            this.error("Invalid " + this._elementName + "; missing 'field'.");
        }
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this._depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this._elementName + "'.");
            }
            if (this._foundSelector || this._foundField) {
                this.error("An annotation may only appear as the first child of '" + this._elementName + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if ("selector".equals(string)) {
            if (this._foundField) {
                String string3 = "The 'selector' element of '" + this._elementName + "' must appear before any 'field' elements.";
                this.error(string3);
            }
            if (this._foundSelector) {
                this.error("Only one (1) 'selector' may appear as a child of '" + this._elementName + "'.");
            }
            this._foundSelector = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(string, attributeSet);
        } else if ("field".equals(string)) {
            this._foundField = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(string, attributeSet);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(string, string2);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this._unmarshaller.getObject();
            this._identityConstraint.addAnnotation(annotation);
        } else if ("selector".equals(string)) {
            IdentitySelector identitySelector = (IdentitySelector)this._unmarshaller.getObject();
            this._identityConstraint.setSelector(identitySelector);
        } else if ("field".equals(string)) {
            IdentityField identityField = (IdentityField)this._unmarshaller.getObject();
            this._identityConstraint.addField(identityField);
        }
        this._unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(cArray, n, n2);
        }
    }
}

