/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class DoubleValidator
extends PatternValidator
implements TypeValidator {
    private boolean _isFixed = false;
    private double _fixed = 0.0;
    private boolean _isThereMinInclusive = false;
    private double _minInclusive = 0.0;
    private boolean _isThereMaxInclusive = false;
    private double _maxInclusive = 0.0;
    private boolean _isThereMinExclusive = false;
    private double _minExclusive = 0.0;
    private boolean _isThereMaxExclusive = false;
    private double _maxExclusive = 0.0;

    public void setFixed(double d) {
        this._fixed = d;
        this._isFixed = true;
    }

    public void setMinExclusive(double d) {
        this._minExclusive = d;
        this._isThereMinExclusive = true;
    }

    public void setMinInclusive(double d) {
        this._minInclusive = d;
        this._isThereMinInclusive = true;
    }

    public void setMaxExclusive(double d) {
        this._maxExclusive = d;
        this._isThereMaxExclusive = true;
    }

    public void setMaxInclusive(double d) {
        this._maxInclusive = d;
        this._isThereMaxInclusive = true;
    }

    public void validate(double d) throws ValidationException {
        if (this._isFixed && d != this._fixed) {
            String string = d + " is not equal to the fixed value of ";
            string = string + this._fixed;
            throw new ValidationException(string);
        }
        if (this._isThereMinInclusive && d < this._minInclusive) {
            String string = d + " is less than the minimum allowable ";
            string = string + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMinExclusive && d <= this._minExclusive) {
            String string = d + " is less than the minimum allowable ";
            string = string + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMaxInclusive && d > this._maxInclusive) {
            String string = d + " is greater than the maximum allowable ";
            string = string + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (this._isThereMaxExclusive && d >= this._maxExclusive) {
            String string = d + " is greater than the maximum allowable ";
            string = string + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Double.toString(d));
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "doubleValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        double d = 0.0;
        try {
            d = new Double(object.toString());
        }
        catch (Exception exception) {
            String string = "Expecting a double, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(d);
    }
}

