/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JClass;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JConstructor {
    private JModifiers modifiers = null;
    private JNamedMap params = null;
    private JClass declaringClass = null;
    private JSourceCode sourceCode = null;

    protected JConstructor(JClass jClass) {
        this.declaringClass = jClass;
        this.modifiers = new JModifiers();
        this.params = new JNamedMap();
        this.sourceCode = new JSourceCode();
    }

    public void addParameter(JParameter jParameter) throws IllegalArgumentException {
        JType jType;
        if (jParameter == null) {
            return;
        }
        if (this.params.get(jParameter.getName()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("A parameter already exists for the constructor, ");
            stringBuffer.append(this.declaringClass.getName());
            stringBuffer.append(", with the name: ");
            stringBuffer.append(jParameter.getName());
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        this.params.put(jParameter.getName(), jParameter);
        if (this.declaringClass != null && !(jType = jParameter.getType()).isPrimitive()) {
            this.declaringClass.addImport(jType.getName());
        }
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public JParameter[] getParameters() {
        JParameter[] jParameterArray = new JParameter[this.params.size()];
        int n = 0;
        while (n < jParameterArray.length) {
            jParameterArray[n] = (JParameter)this.params.get(n);
            ++n;
        }
        return jParameterArray;
    }

    public JSourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void print(JSourceWriter jSourceWriter) {
        if (this.modifiers.isPrivate()) {
            jSourceWriter.write("private");
        } else if (this.modifiers.isProtected()) {
            jSourceWriter.write("protected");
        } else {
            jSourceWriter.write("public");
        }
        jSourceWriter.write(32);
        jSourceWriter.write(this.declaringClass.getLocalName());
        jSourceWriter.write(40);
        int n = 0;
        while (n < this.params.size()) {
            if (n > 0) {
                jSourceWriter.write(", ");
            }
            jSourceWriter.write(this.params.get(n));
            ++n;
        }
        jSourceWriter.writeln(") {");
        this.sourceCode.print(jSourceWriter);
        if (!jSourceWriter.isNewline()) {
            jSourceWriter.writeln();
        }
        jSourceWriter.write("} //-- ");
        jSourceWriter.writeln(this.toString());
    }

    public void setModifiers(JModifiers jModifiers) {
        this.modifiers = jModifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void setSourceCode(String string) {
        this.sourceCode = new JSourceCode(string);
    }

    public void setSourceCode(JSourceCode jSourceCode) {
        this.sourceCode = jSourceCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declaringClass.getName());
        stringBuffer.append('(');
        int n = 0;
        while (n < this.params.size()) {
            JParameter jParameter = (JParameter)this.params.get(n);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(jParameter.getType().getName());
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

