/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadOnlyCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$ReadOnlyCache == null ? (class$net$sf$hibernate$cache$ReadOnlyCache = ReadOnlyCache.class$("net.sf.hibernate.cache.ReadOnlyCache")) : class$net$sf$hibernate$cache$ReadOnlyCache));
    private boolean minimalPuts;
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadOnlyCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public synchronized Object get(Object key, long timestamp) throws CacheException {
        Object result = this.cache.get(key);
        if (result != null && log.isDebugEnabled()) {
            log.debug((Object)("Cache hit: " + key));
        }
        return result;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key) {
        log.error((Object)("Application attempted to edit read only item: " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public synchronized boolean put(Object key, Object value, long timestamp) throws CacheException {
        if (this.minimalPuts && this.cache.get(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("item already cached: " + key));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching: " + key));
        }
        this.cache.put(key, value);
        return true;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock lock) {
        log.error((Object)("Application attempted to edit read only item: " + key));
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    public void afterUpdate(Object key, Object value, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        log.error((Object)("Application attempted to edit read only item: " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public void afterInsert(Object key, Object value) throws CacheException {
    }

    public void evict(Object key) throws CacheException {
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
        log.error((Object)("Application attempted to edit read only item: " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        this.minimalPuts = minimalPuts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

