/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.engine;

import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.persister.ClassPersister;

public final class Key
implements Serializable {
    private final Serializable id;
    private final Serializable identifierSpace;
    private final Class clazz;

    private Key(Serializable id, Serializable identifierSpace, Class clazz) {
        if (id == null) {
            throw new AssertionFailure("null identifier");
        }
        this.id = id;
        this.identifierSpace = identifierSpace;
        this.clazz = clazz;
    }

    public Key(Serializable id, ClassPersister p) {
        this(id, p.getIdentifierSpace(), p.getMappedClass());
    }

    public Serializable getIdentifier() {
        return this.id;
    }

    public Class getMappedClass() {
        return this.clazz;
    }

    public boolean equals(Object other) {
        Key otherKey = (Key)other;
        return otherKey.identifierSpace.equals(this.identifierSpace) && otherKey.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }
}

