/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.TableMetadata;

public class DatabaseMetadata {
    private final Map tables = new HashMap();
    private final Set sequences = new HashSet();
    private DatabaseMetaData meta;

    public DatabaseMetadata(Connection connection, Dialect dialect) throws SQLException {
        this.meta = connection.getMetaData();
        this.initSequences(connection, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetadata getTableMetadata(String name) throws HibernateException {
        TableMetadata table = null;
        if (name != null && (table = (TableMetadata)this.tables.get(name.toUpperCase())) == null) {
            String[] types = new String[]{"TABLE"};
            ResultSet rs = null;
            try {
                try {
                    rs = this.meta.getTables(null, "%", name.toUpperCase(), types);
                    while (rs.next()) {
                        if (!name.equalsIgnoreCase(rs.getString("TABLE_NAME"))) continue;
                        table = new TableMetadata(rs, this.meta);
                        this.tables.put(name.toUpperCase(), table);
                        break;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new HibernateException(e);
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSequences(Connection connection, Dialect dialect) throws SQLException {
        Statement statement;
        block7: {
            String sql = dialect.getQuerySequencesString();
            if (sql == null) {
                return;
            }
            statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.sequences.add(rs.getString(1).toUpperCase());
                }
                Object var7_6 = null;
                if (rs == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    public boolean isSequence(Object key) {
        return key instanceof String && this.sequences.contains(((String)key).toUpperCase());
    }

    public boolean isTable(Object key) throws HibernateException {
        return key instanceof String && this.getTableMetadata((String)key) != null;
    }
}

