/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Type;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator();
    private static final Type DISPATCHER = TypeUtils.parseType("net.sf.cglib.proxy.Dispatcher");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    DispatcherGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context) {
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (Modifier.isProtected(method.getModifiers())) continue;
            CodeEmitter e = ce.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            context.emitCallback(e, context.getIndex(method));
            e.invoke_interface(DISPATCHER, LOAD_OBJECT);
            e.checkcast(Type.getType(method.getDeclaringClass()));
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context) {
    }
}

