/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sen.Node;
import net.java.sen.SenUtils;
import net.java.sen.Token;
import net.java.sen.Viterbi;
import net.java.sen.ja.JapaneseTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringTagger {
    private static Log log;
    private static HashMap hash;
    private Viterbi viterbi = null;
    private Node node = null;
    Token[] token = null;
    int cnt = 0;
    private static StringTagger tagger;
    private String DEFAULT_CONFIG = "conf/sen.xml";
    protected String unknownPos = null;
    String tokenFile = null;
    String doubleArrayFile = null;
    String posInfoFile = null;
    String connectFile = null;
    String charset = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.StringTagger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        hash = new HashMap();
        tagger = null;
    }

    private StringTagger(Locale locale) throws IOException, IllegalArgumentException {
        if (!locale.equals(Locale.JAPANESE)) {
            throw new IllegalArgumentException("Locale '" + locale.getDisplayName() + "' isn't supported.");
        }
        this.init_ja(this.DEFAULT_CONFIG);
    }

    public static synchronized StringTagger getInstance(Locale locale) throws IOException, IllegalArgumentException {
        Object tagger = hash.get(locale);
        if (tagger == null) {
            tagger = new StringTagger(locale);
            hash.put(locale, tagger);
            return (StringTagger)tagger;
        }
        return (StringTagger)tagger;
    }

    private void init_ja(String confFile) throws IOException {
        String confPath = String.valueOf(System.getProperty("sen.home")) + System.getProperty("file.separator") + confFile;
        this.readConfig(confPath);
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.tokenFile, this.doubleArrayFile, this.posInfoFile, this.connectFile, this.charset);
        this.viterbi = new Viterbi(tokenizer);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Token[] analyze(String input) throws IOException {
        if (StringTagger.log.isDebugEnabled()) {
            StringTagger.log.debug((Object)("analyzer:" + input));
        }
        len = 0;
        iter = node = this.viterbi.analyze((char[])input.toCharArray()).next;
        if (node != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            ++len;
            iter = iter.next;
lbl9:
            // 2 sources

            ** while (iter.next != null)
        }
lbl10:
        // 1 sources

        this.token = new Token[len];
        i = 0;
        while (node.next != null) {
            this.token[i] = new Token(node);
            if (this.token[i].getPos() == null) {
                this.token[i].setPos(this.unknownPos);
            }
            ++i;
            node = node.next;
        }
        this.cnt = 0;
        return this.token;
    }

    public Token next() {
        if (this.token == null && this.cnt == this.token.length) {
            return null;
        }
        return this.token[this.cnt++];
    }

    public boolean hasNext() {
        return this.token != null || this.cnt != this.token.length;
    }

    private void readConfig(String confFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(confFile));
            NodeList nl = doc.getFirstChild().getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Node n = nl.item(i);
                if (n.getNodeType() == 1) {
                    String nn = n.getNodeName();
                    String value = n.getFirstChild().getNodeValue();
                    if (nn.equals("charset")) {
                        this.charset = value;
                    } else if (nn.equals("unknown-pos")) {
                        this.unknownPos = value;
                    }
                    if (nn.equals("dictionary")) {
                        NodeList dnl = n.getChildNodes();
                        int j = 0;
                        while (j < dnl.getLength()) {
                            org.w3c.dom.Node dn = dnl.item(j);
                            if (dn.getNodeType() == 1) {
                                String dnn = dn.getNodeName();
                                if (dn.getFirstChild() == null) {
                                    throw new IllegalArgumentException("element '" + dnn + "' is empty");
                                }
                                String dvalue = dn.getFirstChild().getNodeValue();
                                if (dnn.equals("connection-cost")) {
                                    this.connectFile = SenUtils.getPath(dvalue);
                                } else if (dnn.equals("double-array-trie")) {
                                    this.doubleArrayFile = SenUtils.getPath(dvalue);
                                } else if (dnn.equals("token")) {
                                    this.tokenFile = SenUtils.getPath(dvalue);
                                } else if (dnn.equals("pos-info")) {
                                    this.posInfoFile = SenUtils.getPath(dvalue);
                                } else {
                                    throw new IllegalArgumentException("element '" + dnn + "' is invalid");
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

