/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.java.sen.io.FileAccessor;

public class FullBufferedReader
implements FileAccessor {
    byte[] buf;
    int pos = 0;

    public FullBufferedReader(String name) throws IOException {
        this(new File(name));
    }

    public FullBufferedReader(File file) throws IOException {
        this.buf = new byte[(int)file.length()];
        FileInputStream is = new FileInputStream(file);
        ((InputStream)is).read(this.buf);
        ((InputStream)is).close();
    }

    public void seek(int pos) throws IOException {
        if (pos < 0 || pos >= this.buf.length) {
            throw new IOException("File position is invalid. File size is " + this.buf.length + " but specified position is " + pos);
        }
        this.pos = pos;
    }

    public void seek(long pos) throws IOException {
        this.seek((int)pos);
    }

    public short readShort() {
        int i1;
        i1 = (i1 = this.buf[this.pos++]) >= 0 ? i1 : 256 + i1;
        int i2 = this.buf[this.pos++];
        i2 = i2 >= 0 ? i2 : 256 + i2;
        return (short)((i1 << 8) + (i2 << 0));
    }

    public int readInt() {
        int i1;
        i1 = (i1 = this.buf[this.pos++]) >= 0 ? i1 : 256 + i1;
        int i2 = this.buf[this.pos++];
        i2 = i2 >= 0 ? i2 : 256 + i2;
        int i3 = this.buf[this.pos++];
        i3 = i3 >= 0 ? i3 : 256 + i3;
        int i4 = this.buf[this.pos++];
        i4 = i4 >= 0 ? i4 : 256 + i4;
        return (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
    }

    public int read() {
        int b;
        return (b = this.buf[this.pos++]) >= 0 ? b : 256 + b;
    }

    public int read(byte[] b, int start, int length) {
        int l1 = start + length;
        int i = start;
        while (i < start + length) {
            if (i >= b.length) break;
            try {
                b[i] = this.buf[this.pos];
                ++this.pos;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("input length = " + b.length);
                System.out.println("pos of input buf = " + i);
                System.out.println("buffer length=" + this.buf.length);
                System.out.println("current pos=" + this.pos);
            }
            ++i;
        }
        return 1;
    }

    public void close() throws IOException {
    }
}

