/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.ja;

import java.io.IOException;
import net.java.sen.CToken;
import net.java.sen.Node;
import net.java.sen.Tokenizer;

public class JapaneseTokenizer
extends Tokenizer {
    final int OTHER = 128;
    final int SPACE = 129;
    final int KANJI = 130;
    final int KATAKANA = 131;
    final int HIRAGANA = 132;
    final int HALF_WIDTH = 133;

    public JapaneseTokenizer(String tokenFile, String doubleArrayFile, String posInfoFile, String connectFile, String charset) throws IOException {
        super(tokenFile, doubleArrayFile, posInfoFile, connectFile, charset);
    }

    public int getCharClass(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        int type = Character.getType(Character.toLowerCase(c));
        if (ub == Character.UnicodeBlock.BASIC_LATIN) {
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                return 129;
            }
            return type;
        }
        if (ub == Character.UnicodeBlock.HIRAGANA) {
            return 132;
        }
        if (ub == Character.UnicodeBlock.KATAKANA && type != 23) {
            return 131;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return 130;
        }
        if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
            return 133;
        }
        return 128;
    }

    public Node lookup(char[] c, int begin) throws IOException {
        int begin3;
        Node newNode;
        Node resultNode = null;
        int end = c.length;
        int[] char_class = new int[1];
        int begin2 = this.skipCharClass(c, begin, end, 129, char_class);
        if (begin2 == end) {
            return null;
        }
        CToken[] t = this.dic.commonPrefixSearch(c, begin2);
        int i = 0;
        while (t[i] != null) {
            newNode = this.getNewNode();
            newNode.token = t[i];
            newNode.length = t[i].length;
            newNode.surface = c;
            newNode.begin = begin2;
            newNode.end = begin2 - begin + t[i].length;
            newNode.rnext = resultNode;
            resultNode = newNode;
            ++i;
        }
        if (resultNode != null && (char_class[0] == 132 || char_class[0] == 130)) {
            return resultNode;
        }
        switch (char_class[0]) {
            case 128: 
            case 130: 
            case 132: {
                begin3 = begin2 + 1;
                break;
            }
            default: {
                begin3 = this.skipCharClass(c, begin2 + 1, end, char_class[0]);
            }
        }
        newNode = this.getNewNode();
        newNode.token = this.unknownToken;
        newNode.surface = c;
        newNode.begin = begin2;
        newNode.length = begin3 - begin2;
        newNode.end = begin3 - begin;
        newNode.termInfo = null;
        newNode.rnext = resultNode;
        return newNode;
    }
}

