/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DoubleArrayTrie {
    private static final int BUF_SIZE = 500000;
    private static Log log = LogFactory.getLog((Class)(class$net$java$sen$util$DoubleArrayTrie == null ? (class$net$java$sen$util$DoubleArrayTrie = DoubleArrayTrie.class$("net.java.sen.util.DoubleArrayTrie")) : class$net$java$sen$util$DoubleArrayTrie));
    private int[] array = null;
    private int[] used = null;
    private int size = 0;
    private int alloc_size = 0;
    private char[][] str;
    private int str_size;
    private int[] len;
    private int[] val;
    private int next_check_pos;
    private int no_delete = 0;
    static /* synthetic */ Class class$net$java$sen$util$DoubleArrayTrie;

    public void load(String fileName) throws IOException {
        log.info((Object)("loading double array trie dict = " + fileName));
        long start = System.currentTimeMillis();
        File file = new File(fileName);
        this.array = new int[(int)(file.length() / 4L)];
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 500000));
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = is.readInt();
        }
        log.info((Object)("loaded time = " + (double)(System.currentTimeMillis() - start) / 1000.0 + "[ms]"));
    }

    int[] _resize(int[] ptr, int n, int l, int v) {
        int i;
        int[] tmp = new int[l];
        l = ptr != null ? ptr.length : 0;
        for (i = 0; i < l; ++i) {
            tmp[i] = ptr[i];
        }
        for (i = l; i < l; ++i) {
            tmp[i] = v;
        }
        ptr = null;
        return tmp;
    }

    int resize(int new_size) {
        this.array = this._resize(this.array, this.alloc_size << 1, new_size << 1, 0);
        this.used = this._resize(this.used, this.alloc_size, new_size, 0);
        this.alloc_size = new_size;
        return new_size;
    }

    int fetch(Node parent, Vector siblings) {
        int prev = 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)("parent.left=" + parent.left));
            log.trace((Object)("parent.right=" + parent.right));
            log.trace((Object)("parent.depth=" + parent.depth));
        }
        for (int i = parent.left; i < parent.right; ++i) {
            if ((this.len != null ? this.len[i] : this.str[i].length) < parent.depth) continue;
            char[] tmp = this.str[i];
            int cur = 0;
            if ((this.len != null ? this.len[i] : this.str[i].length) != parent.depth) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("tmp[" + parent.depth + "]=" + tmp[parent.depth]));
                }
                cur = tmp[parent.depth] + '\u0001';
            }
            if (prev > cur) {
                log.error((Object)"given strings are not sorted.\n");
                throw new RuntimeException("Fatal: given strings are not sorted.\n");
            }
            if (cur != prev || siblings.size() == 0) {
                Node tmp_node = new Node();
                tmp_node.depth = parent.depth + 1;
                tmp_node.code = cur;
                tmp_node.left = i;
                if (siblings.size() != 0) {
                    ((Node)siblings.get((int)(siblings.size() - 1))).right = i;
                }
                siblings.add(tmp_node);
            }
            prev = cur;
        }
        if (siblings.size() != 0) {
            ((Node)siblings.get((int)(siblings.size() - 1))).right = parent.right;
        }
        return siblings.size();
    }

    int insert(Vector siblings) {
        int i;
        int begin = 0;
        int pos = (((Node)siblings.get((int)0)).code + 1 > this.next_check_pos ? ((Node)siblings.get((int)0)).code + 1 : this.next_check_pos) - 1;
        int nonzero_num = 0;
        boolean first = false;
        while (true) {
            int t;
            if ((t = ++pos) > this.alloc_size) {
                this.resize((int)((double)t * 1.05));
            }
            if (this.array[(pos << 1) + 1] != 0) {
                ++nonzero_num;
                continue;
            }
            if (!first) {
                this.next_check_pos = pos;
                first = true;
            }
            if ((t = (begin = pos - ((Node)siblings.get((int)0)).code) + ((Node)siblings.get((int)(siblings.size() - 1))).code) > this.alloc_size) {
                this.resize((int)((double)t * 1.05));
            }
            if (this.used[begin] != 0) continue;
            boolean flag = false;
            for (int i2 = 1; i2 < siblings.size(); ++i2) {
                if (this.array[(begin + ((Node)siblings.get((int)i2)).code << 1) + 1] == 0) continue;
                flag = true;
                break;
            }
            if (!flag) break;
        }
        if (1.0 * (double)nonzero_num / (double)(pos - this.next_check_pos + 1) >= 0.95) {
            this.next_check_pos = pos;
        }
        this.used[begin] = 1;
        this.size = this.size > begin + ((Node)siblings.get((int)(siblings.size() - 1))).code + 1 ? this.size : begin + ((Node)siblings.get((int)(siblings.size() - 1))).code + 1;
        for (i = 0; i < siblings.size(); ++i) {
            this.array[(begin + ((Node)siblings.get((int)i)).code << 1) + 1] = begin;
        }
        for (i = 0; i < siblings.size(); ++i) {
            int ins;
            Vector new_siblings = new Vector();
            if (this.fetch((Node)siblings.get(i), new_siblings) == 0) {
                int n = this.array[begin + ((Node)siblings.get((int)i)).code << 1] = this.val != null ? -this.val[((Node)siblings.get((int)i)).left] - 1 : -((Node)siblings.get((int)i)).left - 1;
                if (this.val == null || -this.val[((Node)siblings.get((int)i)).left] - 1 < 0) continue;
                log.error((Object)"negative value is assgined.");
                throw new RuntimeException("Fatal: negative value is assgined.");
            }
            this.array[begin + ((Node)siblings.get((int)i)).code << 1] = ins = this.insert(new_siblings);
        }
        return begin;
    }

    void clear() {
        this.array = null;
        this.used = null;
        this.alloc_size = 0;
        this.size = 0;
        this.no_delete = 0;
    }

    int get_unit_size() {
        return 8;
    }

    int get_size() {
        return this.size;
    }

    int get_nonzero_size() {
        int result = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[(i << 1) + 1] == 0) continue;
            ++result;
        }
        return result;
    }

    public int build(char[][] _str, int[] _len, int[] _val) {
        return this.build(_str, _len, _val, _str.length);
    }

    public int build(char[][] _str, int[] _len, int[] _val, int size) {
        if (_str == null) {
            return 0;
        }
        if (_str.length != _val.length) {
            log.warn((Object)"index and text should be same size.");
            return 0;
        }
        this.str = _str;
        this.len = _len;
        this.str_size = size;
        this.val = _val;
        this.resize(10240);
        this.array[0] = 1;
        this.next_check_pos = 0;
        Node root_node = new Node();
        root_node.left = 0;
        root_node.right = this.str_size;
        root_node.depth = 0;
        Vector siblings = new Vector();
        log.trace((Object)"---fetch---");
        this.fetch(root_node, siblings);
        log.trace((Object)"---insert---");
        this.insert(siblings);
        this.used = null;
        return size;
    }

    public int search(char[] key, int pos, int len) {
        int p;
        if (len == 0) {
            len = key.length;
        }
        int b = this.array[0];
        for (int i = pos; i < len; ++i) {
            p = b + key[i] + 1;
            if (b != this.array[(p << 1) + 1]) {
                return -1;
            }
            b = this.array[p << 1];
        }
        p = b;
        int n = this.array[p << 1];
        if (b == this.array[(p << 1) + 1] && n < 0) {
            return -n - 1;
        }
        return -1;
    }

    public int commonPrefixSearch(char[] key, int[] result, int pos, int len) {
        int n;
        int p;
        if (len == 0) {
            len = key.length;
        }
        int b = this.array[0];
        int num = 0;
        for (int i = pos; i < len; ++i) {
            if (key[i] == '\n' || key[i] == '\r') continue;
            p = b;
            n = this.array[p << 1];
            if (b == this.array[(p << 1) + 1] && n < 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("result[" + num + "]=" + (-n - 1)));
                }
                if (num < result.length) {
                    result[num] = -n - 1;
                } else {
                    log.warn((Object)"result array size may not enough");
                }
                ++num;
            }
            if ((p = b + key[i] + 1) << 1 > this.array.length) {
                log.warn((Object)"p range is over.");
                log.warn((Object)("(p<<1,array.length)=(" + (p << 1) + "," + this.array.length + ")"));
                return num;
            }
            if (b == this.array[(p << 1) + 1]) {
                b = this.array[p << 1];
                continue;
            }
            return num;
        }
        p = b;
        n = this.array[p << 1];
        if (b == this.array[(p << 1) + 1] && n < 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("result[" + num + "]=" + (-n - 1)));
            }
            if (num < result.length) {
                result[num] = -n - 1;
            } else {
                log.warn((Object)"result array size may not enough");
            }
            ++num;
        }
        return num;
    }

    public void save(String file) throws IOException {
        long start = System.currentTimeMillis();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        int dsize = this.alloc_size << 1;
        for (int i = 0; i < dsize; ++i) {
            out.writeInt(this.array[i]);
        }
        out.close();
        log.info((Object)("save time = " + (double)(System.currentTimeMillis() - start) / 1000.0 + "[s]"));
    }

    public static void dumpChar(char[] c, String message) {
        System.err.println("message=" + message);
        for (int i = 0; i < c.length; ++i) {
            System.err.print(c[i] + ",");
        }
        System.err.println();
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Node {
        int code;
        int depth;
        int left;
        int right;

        private Node() {
        }
    }
}

