/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.bzip2.BZip2Constants;
import org.apache.commons.compress.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int UPPER_BYTE_MASK = -256;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int QSORT_STACK_SIZE = 1000;
    private CRC m_crc = new CRC();
    private boolean[] m_inUse = new boolean[256];
    private char[] m_seqToUnseq = new char[256];
    private char[] m_unseqToSeq = new char[256];
    private char[] m_selector = new char[18002];
    private char[] m_selectorMtf = new char[18002];
    private int[] m_mtfFreq = new int[258];
    private int m_currentChar = -1;
    private int m_runLength;
    private boolean m_closed;
    private int[] m_incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean m_blockRandomised;
    private int m_blockSize100k;
    private int m_bsBuff;
    private int m_bsLive;
    private int m_last;
    private int m_origPtr;
    private int m_allowableBlockSize;
    private char[] m_block;
    private int m_blockCRC;
    private int m_combinedCRC;
    private OutputStream m_bsStream;
    private boolean m_firstAttempt;
    private int[] m_ftab;
    private int m_nInUse;
    private int m_nMTF;
    private int[] m_quadrant;
    private short[] m_szptr;
    private int m_workDone;
    private int m_workFactor;
    private int m_workLimit;
    private int[] m_zptr;

    public CBZip2OutputStream(OutputStream output) throws IOException {
        this(output, 9);
    }

    public CBZip2OutputStream(OutputStream output, int blockSize) throws IOException {
        this.bsSetStream(output);
        this.m_workFactor = 50;
        int outBlockSize = blockSize;
        if (outBlockSize > 9) {
            outBlockSize = 9;
        }
        if (outBlockSize < 1) {
            outBlockSize = 1;
        }
        this.m_blockSize100k = outBlockSize;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private static void hbMakeCodeLengths(char[] len, int[] freq, int alphaSize, int maxLen) {
        int[] heap = new int[260];
        int[] weights = new int[516];
        int[] parent = new int[516];
        int i = 0;
        while (i < alphaSize) {
            weights[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
            ++i;
        }
        block1: while (true) {
            int j;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weights[0] = 0;
            parent[0] = -2;
            i = 1;
            while (i <= alphaSize) {
                parent[i] = -1;
                heap[++nHeap] = i;
                zz = nHeap;
                int tmp = heap[zz];
                while (weights[tmp] < weights[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
                ++i;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int weight;
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp = 0;
                zz = 1;
                tmp = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weights[heap[yy + 1]] < weights[heap[yy]]) {
                        ++yy;
                    }
                    if (weights[tmp] < weights[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp;
                parent[n1] = ++nNodes;
                parent[n2] = nNodes;
                int v1 = weights[n1];
                int v2 = weights[n2];
                weights[nNodes] = weight = CBZip2OutputStream.calculateWeight(v1, v2);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                int zz2 = 0;
                int tmp2 = 0;
                zz2 = nHeap;
                tmp2 = heap[zz2];
                while (weights[tmp2] < weights[heap[zz2 >> 1]]) {
                    heap[zz2] = heap[zz2 >> 1];
                    zz2 >>= 1;
                }
                heap[zz2] = tmp2;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            i = 1;
            while (i <= alphaSize) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                len[i - 1] = (char)j;
                if (j > maxLen) {
                    tooLong = true;
                }
                ++i;
            }
            if (!tooLong) break;
            i = 1;
            while (true) {
                if (i >= alphaSize) continue block1;
                j = weights[i] >> 8;
                j = 1 + j / 2;
                weights[i] = j << 8;
                ++i;
            }
            break;
        }
    }

    private static int calculateWeight(int v1, int v2) {
        int upper = (v1 & 0xFFFFFF00) + (v2 & 0xFFFFFF00);
        int v1Lower = v1 & 0xFF;
        int v2Lower = v2 & 0xFF;
        int nnnn = v1Lower > v2Lower ? v1Lower : v2Lower;
        return upper | 1 + nnnn;
    }

    private static void panic() {
        System.out.println("panic");
    }

    public void close() throws IOException {
        if (this.m_closed) {
            return;
        }
        if (this.m_runLength > 0) {
            this.writeRun();
        }
        this.m_currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.m_closed = true;
        super.close();
        this.m_bsStream.close();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.m_bsStream.flush();
    }

    public void write(int bv) throws IOException {
        int b = (256 + bv) % 256;
        if (this.m_currentChar != -1) {
            if (this.m_currentChar == b) {
                ++this.m_runLength;
                if (this.m_runLength > 254) {
                    this.writeRun();
                    this.m_currentChar = -1;
                    this.m_runLength = 0;
                }
            } else {
                this.writeRun();
                this.m_runLength = 1;
                this.m_currentChar = b;
            }
        } else {
            this.m_currentChar = b;
            ++this.m_runLength;
        }
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.m_blockSize100k;
        this.m_block = new char[n + 1 + 20];
        this.m_quadrant = new int[n + 20];
        this.m_zptr = new int[n];
        this.m_ftab = new int[65537];
        if (this.m_block == null || this.m_quadrant == null || this.m_zptr != null) {
            // empty if block
        }
        this.m_szptr = new short[2 * n];
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.m_bsLive > 0) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
    }

    private void bsPutIntVS(int numBits, int c) throws IOException {
        this.bsW(numBits, c);
    }

    private void bsPutUChar(int c) throws IOException {
        this.bsW(8, c);
    }

    private void bsPutint(int u) throws IOException {
        this.bsW(8, u >> 24 & 0xFF);
        this.bsW(8, u >> 16 & 0xFF);
        this.bsW(8, u >> 8 & 0xFF);
        this.bsW(8, u & 0xFF);
    }

    private void bsSetStream(OutputStream f) {
        this.m_bsStream = f;
        this.m_bsLive = 0;
        this.m_bsBuff = 0;
    }

    private void bsW(int n, int v) throws IOException {
        while (this.m_bsLive >= 8) {
            int ch = this.m_bsBuff >> 24;
            this.m_bsStream.write(ch);
            this.m_bsBuff <<= 8;
            this.m_bsLive -= 8;
        }
        this.m_bsBuff |= v << 32 - this.m_bsLive - n;
        this.m_bsLive += n;
    }

    private void doReversibleTransformation() {
        this.m_workLimit = this.m_workFactor * this.m_last;
        this.m_workDone = 0;
        this.m_blockRandomised = false;
        this.m_firstAttempt = true;
        this.mainSort();
        if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
            this.randomiseBlock();
            this.m_workLimit = 0;
            this.m_workDone = 0;
            this.m_blockRandomised = true;
            this.m_firstAttempt = false;
            this.mainSort();
        }
        this.m_origPtr = -1;
        int i = 0;
        while (i <= this.m_last) {
            if (this.m_zptr[i] == 0) {
                this.m_origPtr = i;
                break;
            }
            ++i;
        }
        if (this.m_origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.m_blockCRC = this.m_crc.getFinalCRC();
        this.m_combinedCRC = this.m_combinedCRC << 1 | this.m_combinedCRC >>> 31;
        this.m_combinedCRC ^= this.m_blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.m_blockCRC);
        if (this.m_blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.m_combinedCRC);
        this.bsFinishedWithStream();
    }

    private boolean fullGtU(int i1, int i2) {
        char c1 = this.m_block[i1 + 1];
        char c2 = this.m_block[i2 + 1];
        if (c1 != c2) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
            return c1 > c2;
        }
        ++i1;
        ++i2;
        int k = this.m_last + 1;
        do {
            if ((c1 = this.m_block[i1 + 1]) != (c2 = this.m_block[i2 + 1])) {
                return c1 > c2;
            }
            int s1 = this.m_quadrant[i1];
            int s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.m_block[++i1 + 1]) != (c2 = this.m_block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.m_quadrant[i1];
            s2 = this.m_quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            ++i2;
            if (++i1 > this.m_last) {
                i1 -= this.m_last;
                --i1;
            }
            if (i2 > this.m_last) {
                i2 -= this.m_last;
                --i2;
            }
            ++this.m_workDone;
        } while ((k -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.m_nInUse + 1;
        int i = 0;
        while (i <= EOB) {
            this.m_mtfFreq[i] = 0;
            ++i;
        }
        int wr = 0;
        int zPend = 0;
        i = 0;
        while (i < this.m_nInUse) {
            yy[i] = (char)i;
            ++i;
        }
        i = 0;
        while (i <= this.m_last) {
            char ll_i = this.m_unseqToSeq[this.m_block[this.m_zptr[i]]];
            int j = 0;
            char tmp = yy[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j];
                yy[j] = tmp2;
            }
            yy[0] = tmp;
            if (j == 0) {
                ++zPend;
            } else {
                if (zPend > 0) {
                    --zPend;
                    while (true) {
                        switch (zPend % 2) {
                            case 0: {
                                this.m_szptr[wr] = 0;
                                ++wr;
                                this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                                break;
                            }
                            case 1: {
                                this.m_szptr[wr] = 1;
                                ++wr;
                                this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                            }
                        }
                        if (zPend < 2) break;
                        zPend = (zPend - 2) / 2;
                    }
                    zPend = 0;
                }
                this.m_szptr[wr] = (short)(j + 1);
                ++wr;
                int n = j + 1;
                this.m_mtfFreq[n] = this.m_mtfFreq[n] + 1;
            }
            ++i;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.m_szptr[wr] = 0;
                        ++wr;
                        this.m_mtfFreq[0] = this.m_mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.m_szptr[wr] = 1;
                        ++wr;
                        this.m_mtfFreq[1] = this.m_mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.m_szptr[wr] = (short)EOB;
        int n = EOB;
        this.m_mtfFreq[n] = this.m_mtfFreq[n] + 1;
        this.m_nMTF = ++wr;
    }

    private void hbAssignCodes(int[] code, char[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        int n = minLen;
        while (n <= maxLen) {
            int i = 0;
            while (i < alphaSize) {
                if (length[i] == n) {
                    code[i] = vec++;
                }
                ++i;
            }
            vec <<= 1;
            ++n;
        }
    }

    private void initBlock() {
        this.m_crc.initialiseCRC();
        this.m_last = -1;
        int i = 0;
        while (i < 256) {
            this.m_inUse[i] = false;
            ++i;
        }
        this.m_allowableBlockSize = 100000 * this.m_blockSize100k - 20;
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.m_blockSize100k);
        this.m_combinedCRC = 0;
    }

    private void mainSort() {
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        int i = 0;
        while (i < 20) {
            this.m_block[this.m_last + i + 2] = this.m_block[i % (this.m_last + 1) + 1];
            ++i;
        }
        i = 0;
        while (i <= this.m_last + 20) {
            this.m_quadrant[i] = 0;
            ++i;
        }
        this.m_block[0] = this.m_block[this.m_last + 1];
        if (this.m_last < 4000) {
            i = 0;
            while (i <= this.m_last) {
                this.m_zptr[i] = i;
                ++i;
            }
            this.m_firstAttempt = false;
            this.m_workDone = 0;
            this.m_workLimit = 0;
            this.simpleSort(0, this.m_last, 0);
        } else {
            int j;
            char c2;
            i = 0;
            while (i <= 255) {
                bigDone[i] = false;
                ++i;
            }
            i = 0;
            while (i <= 65536) {
                this.m_ftab[i] = 0;
                ++i;
            }
            char c1 = this.m_block[0];
            i = 0;
            while (i <= this.m_last) {
                c2 = this.m_block[i + 1];
                int n = (c1 << 8) + c2;
                this.m_ftab[n] = this.m_ftab[n] + 1;
                c1 = c2;
                ++i;
            }
            i = 1;
            while (i <= 65536) {
                int n = i;
                this.m_ftab[n] = this.m_ftab[n] + this.m_ftab[i - 1];
                ++i;
            }
            c1 = this.m_block[1];
            i = 0;
            while (i < this.m_last) {
                c2 = this.m_block[i + 2];
                j = (c1 << 8) + c2;
                c1 = c2;
                int n = j;
                this.m_ftab[n] = this.m_ftab[n] - 1;
                this.m_zptr[this.m_ftab[j]] = i++;
            }
            int n = j = (this.m_block[this.m_last + 1] << 8) + this.m_block[1];
            this.m_ftab[n] = this.m_ftab[n] - 1;
            this.m_zptr[this.m_ftab[j]] = this.m_last;
            i = 0;
            while (i <= 255) {
                runningOrder[i] = i;
                ++i;
            }
            int h = 1;
            while ((h = 3 * h + 1) <= 256) {
            }
            do {
                i = h /= 3;
                while (i <= 255) {
                    int vv = runningOrder[i];
                    j = i;
                    while (this.m_ftab[runningOrder[j - h] + 1 << 8] - this.m_ftab[runningOrder[j - h] << 8] > this.m_ftab[vv + 1 << 8] - this.m_ftab[vv << 8]) {
                        runningOrder[j] = runningOrder[j - h];
                        if ((j -= h) <= h - 1) break;
                    }
                    runningOrder[j] = vv;
                    ++i;
                }
            } while (h != 1);
            i = 0;
            while (i <= 255) {
                int ss = runningOrder[i];
                j = 0;
                while (j <= 255) {
                    int sb = (ss << 8) + j;
                    if ((this.m_ftab[sb] & 0x200000) != 0x200000) {
                        int hi = (this.m_ftab[sb + 1] & 0xFFDFFFFF) - 1;
                        int lo = this.m_ftab[sb] & 0xFFDFFFFF;
                        if (hi > lo) {
                            this.qSort3(lo, hi, 2);
                            if (this.m_workDone > this.m_workLimit && this.m_firstAttempt) {
                                return;
                            }
                        }
                        int n2 = sb;
                        this.m_ftab[n2] = this.m_ftab[n2] | 0x200000;
                    }
                    ++j;
                }
                bigDone[ss] = true;
                if (i < 255) {
                    int bbStart = this.m_ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    j = 0;
                    while (j < bbSize) {
                        int qVal;
                        int a2update = this.m_zptr[bbStart + j];
                        this.m_quadrant[a2update] = qVal = j >> shifts;
                        if (a2update < 20) {
                            this.m_quadrant[a2update + this.m_last + 1] = qVal;
                        }
                        ++j;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                j = 0;
                while (j <= 255) {
                    copy[j] = this.m_ftab[(j << 8) + ss] & 0xFFDFFFFF;
                    ++j;
                }
                j = this.m_ftab[ss << 8] & 0xFFDFFFFF;
                while (j < (this.m_ftab[ss + 1 << 8] & 0xFFDFFFFF)) {
                    c1 = this.m_block[this.m_zptr[j]];
                    if (!bigDone[c1]) {
                        this.m_zptr[copy[c1]] = this.m_zptr[j] == 0 ? this.m_last : this.m_zptr[j] - 1;
                        char c = c1;
                        copy[c] = copy[c] + 1;
                    }
                    ++j;
                }
                j = 0;
                while (j <= 255) {
                    int n3 = (j << 8) + ss;
                    this.m_ftab[n3] = this.m_ftab[n3] | 0x200000;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void makeMaps() {
        this.m_nInUse = 0;
        int i = 0;
        while (i < 256) {
            if (this.m_inUse[i]) {
                this.m_seqToUnseq[this.m_nInUse] = (char)i;
                this.m_unseqToSeq[i] = (char)this.m_nInUse;
                ++this.m_nInUse;
            }
            ++i;
        }
    }

    private char med3(char a, char b, char c) {
        char t;
        if (a > b) {
            t = a;
            a = b;
            b = t;
        }
        if (b > c) {
            t = b;
            b = c;
            c = t;
        }
        if (a > b) {
            b = a;
        }
        return b;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.m_origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        StackElem[] stack = new StackElem[1000];
        int count = 0;
        while (count < 1000) {
            stack[count] = new StackElem();
            ++count;
        }
        int sp = 0;
        stack[sp].m_ll = loSt;
        stack[sp].m_hh = hiSt;
        stack[sp].m_dd = dSt;
        ++sp;
        while (sp > 0) {
            int n;
            if (sp >= 1000) {
                CBZip2OutputStream.panic();
            }
            int lo = stack[--sp].m_ll;
            int hi = stack[sp].m_hh;
            int d = stack[sp].m_dd;
            if (hi - lo < 20 || d > 10) {
                this.simpleSort(lo, hi, d);
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            char med = this.med3(this.m_block[this.m_zptr[lo] + d + 1], this.m_block[this.m_zptr[hi] + d + 1], this.m_block[this.m_zptr[lo + hi >> 1] + d + 1]);
            int unLo = lo;
            int ltLo = lo;
            int unHi = hi;
            int gtHi = hi;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n = this.m_block[this.m_zptr[unLo] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.m_zptr[unLo];
                        this.m_zptr[unLo] = this.m_zptr[ltLo];
                        this.m_zptr[ltLo] = temp;
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n = this.m_block[this.m_zptr[unHi] + d + 1] - med;
                    if (n == 0) {
                        temp = 0;
                        temp = this.m_zptr[unHi];
                        this.m_zptr[unHi] = this.m_zptr[gtHi];
                        this.m_zptr[gtHi] = temp;
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                temp = 0;
                temp = this.m_zptr[unLo];
                this.m_zptr[unLo] = this.m_zptr[unHi];
                this.m_zptr[unHi] = temp;
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) {
                stack[sp].m_ll = lo;
                stack[sp].m_hh = hi;
                stack[sp].m_dd = d + 1;
                ++sp;
                continue;
            }
            n = ltLo - lo < unLo - ltLo ? ltLo - lo : unLo - ltLo;
            this.vswap(lo, unLo - n, n);
            int m = hi - gtHi < gtHi - unHi ? hi - gtHi : gtHi - unHi;
            this.vswap(unLo, hi - m + 1, m);
            n = lo + unLo - ltLo - 1;
            m = hi - (gtHi - unHi) + 1;
            stack[sp].m_ll = lo;
            stack[sp].m_hh = n;
            stack[sp].m_dd = d;
            stack[++sp].m_ll = n + 1;
            stack[sp].m_hh = m - 1;
            stack[sp].m_dd = d + 1;
            stack[++sp].m_ll = m;
            stack[sp].m_hh = hi;
            stack[sp].m_dd = d;
            ++sp;
        }
    }

    private void randomiseBlock() {
        int rNToGo = 0;
        int rTPos = 0;
        int i = 0;
        while (i < 256) {
            this.m_inUse[i] = false;
            ++i;
        }
        i = 0;
        while (i <= this.m_last) {
            if (rNToGo == 0) {
                rNToGo = (char)BZip2Constants.RAND_NUMS[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n = i + 1;
            this.m_block[n] = (char)(this.m_block[n] ^ (--rNToGo == 1 ? (char)'\u0001' : '\u0000'));
            int n2 = i + 1;
            this.m_block[n2] = (char)(this.m_block[n2] & 0xFF);
            this.m_inUse[this.m_block[i + 1]] = true;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void sendMTFValues() throws IOException {
        len = new char[6][258];
        nSelectors = 0;
        alphaSize = this.m_nInUse + 2;
        t = 0;
        while (t < 6) {
            v = 0;
            while (v < alphaSize) {
                len[t][v] = 15;
                ++v;
            }
            ++t;
        }
        if (this.m_nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        nGroups = this.m_nMTF < 200 ? 2 : (this.m_nMTF < 600 ? 3 : (this.m_nMTF < 1200 ? 4 : (this.m_nMTF < 2400 ? 5 : 6)));
        nPart = nGroups;
        remF = this.m_nMTF;
        gs = 0;
        while (nPart > 0) {
            tFreq = remF / nPart;
            ge = gs - 1;
            aFreq = 0;
            while (aFreq < tFreq && ge < alphaSize - 1) {
                aFreq += this.m_mtfFreq[++ge];
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.m_mtfFreq[ge];
                --ge;
            }
            v = 0;
            while (v < alphaSize) {
                len[nPart - 1][v] = v >= gs && v <= ge ? 0 : 15;
                ++v;
            }
            --nPart;
            gs = ge + 1;
            remF -= aFreq;
        }
        rfreq = new int[6][258];
        fave = new int[6];
        cost = new short[6];
        iter = 0;
        while (iter < 4) {
            t = 0;
            while (t < nGroups) {
                fave[t] = 0;
                ++t;
            }
            t = 0;
            while (t < nGroups) {
                v = 0;
                while (v < alphaSize) {
                    rfreq[t][v] = 0;
                    ++v;
                }
                ++t;
            }
            nSelectors = 0;
            gs = 0;
            while (gs < this.m_nMTF) {
                ge = gs + 50 - 1;
                if (ge >= this.m_nMTF) {
                    ge = this.m_nMTF - 1;
                }
                t = 0;
                while (t < nGroups) {
                    cost[t] = 0;
                    ++t;
                }
                if (nGroups == 6) {
                    cost0 = 0;
                    cost1 = 0;
                    cost2 = 0;
                    cost3 = 0;
                    cost4 = 0;
                    cost5 = 0;
                    i = gs;
                    while (i <= ge) {
                        icv = this.m_szptr[i];
                        cost0 = (short)(cost0 + len[0][icv]);
                        cost1 = (short)(cost1 + len[1][icv]);
                        cost2 = (short)(cost2 + len[2][icv]);
                        cost3 = (short)(cost3 + len[3][icv]);
                        cost4 = (short)(cost4 + len[4][icv]);
                        cost5 = (short)(cost5 + len[5][icv]);
                        ++i;
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    i = gs;
                    while (i <= ge) {
                        icv = this.m_szptr[i];
                        t = 0;
                        while (t < nGroups) {
                            v0 = t;
                            cost[v0] = (short)(cost[v0] + len[t][icv]);
                            ++t;
                        }
                        ++i;
                    }
                }
                bc = 999999999;
                bt = -1;
                t = 0;
                while (t < nGroups) {
                    if (cost[t] < bc) {
                        bc = cost[t];
                        bt = t;
                    }
                    ++t;
                }
                v1 = bt;
                fave[v1] = fave[v1] + 1;
                this.m_selector[nSelectors] = (char)bt;
                ++nSelectors;
                i = gs;
                while (i <= ge) {
                    v2 = rfreq[bt];
                    v3 = this.m_szptr[i];
                    v2[v3] = v2[v3] + 1;
                    ++i;
                }
                gs = ge + 1;
            }
            t = 0;
            while (t < nGroups) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], alphaSize, 20);
                ++t;
            }
            ++iter;
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        pos = new char[6];
        i = 0;
        while (i < nGroups) {
            pos[i] = (char)i;
            ++i;
        }
        i = 0;
        while (i < nSelectors) {
            ll_i = this.m_selector[i];
            j = 0;
            tmp = pos[j];
            while (ll_i != tmp) {
                tmp2 = tmp;
                tmp = pos[++j];
                pos[j] = tmp2;
            }
            pos[0] = tmp;
            this.m_selectorMtf[i] = (char)j;
            ++i;
        }
        code = new int[6][258];
        t = 0;
        while (t < nGroups) {
            minLen = ' ';
            maxLen = '\u0000';
            i = 0;
            while (i < alphaSize) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] < minLen) {
                    minLen = len[t][i];
                }
                ++i;
            }
            if (maxLen > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (minLen < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t], len[t], minLen, maxLen, alphaSize);
            ++t;
        }
        inUse16 = new boolean[16];
        i = 0;
        while (i < 16) {
            inUse16[i] = false;
            j = 0;
            while (j < 16) {
                if (this.m_inUse[i * 16 + j]) {
                    inUse16[i] = true;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            if (inUse16[i]) {
                this.bsW(1, 1);
            } else {
                this.bsW(1, 0);
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            if (inUse16[i]) {
                j = 0;
                while (j < 16) {
                    if (this.m_inUse[i * 16 + j]) {
                        this.bsW(1, 1);
                    } else {
                        this.bsW(1, 0);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        i = 0;
        while (i < nSelectors) {
            j = 0;
            while (j < this.m_selectorMtf[i]) {
                this.bsW(1, 1);
                ++j;
            }
            this.bsW(1, 0);
            ++i;
        }
        t = 0;
        while (t < nGroups) {
            curr = len[t][0];
            this.bsW(5, curr);
            i = 0;
            ** GOTO lbl241
            {
                this.bsW(2, 2);
                ++curr;
                do {
                    if (curr < len[t][i]) continue block30;
                    while (curr > len[t][i]) {
                        this.bsW(2, 3);
                        --curr;
                    }
                    this.bsW(1, 0);
                    ++i;
lbl241:
                    // 2 sources

                } while (i < alphaSize);
            }
            ++t;
        }
        selCtr = 0;
        gs = 0;
        while (gs < this.m_nMTF) {
            ge = gs + 50 - 1;
            if (ge >= this.m_nMTF) {
                ge = this.m_nMTF - 1;
            }
            i = gs;
            while (i <= ge) {
                this.bsW(len[this.m_selector[selCtr]][this.m_szptr[i]], code[this.m_selector[selCtr]][this.m_szptr[i]]);
                ++i;
            }
            gs = ge + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.m_incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h = this.m_incs[hp];
            for (int i = lo + h; i <= hi; ++i) {
                int v = this.m_zptr[i];
                int j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) <= lo + h - 1) break;
                }
                this.m_zptr[j] = v;
                if (++i > hi) break;
                v = this.m_zptr[i];
                j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) <= lo + h - 1) break;
                }
                this.m_zptr[j] = v;
                if (++i > hi) break;
                v = this.m_zptr[i];
                j = i;
                while (this.fullGtU(this.m_zptr[j - h] + d, v + d)) {
                    this.m_zptr[j] = this.m_zptr[j - h];
                    if ((j -= h) <= lo + h - 1) break;
                }
                this.m_zptr[j] = v;
                if (this.m_workDone <= this.m_workLimit || !this.m_firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n) {
        int temp = 0;
        while (n > 0) {
            temp = this.m_zptr[p1];
            this.m_zptr[p1] = this.m_zptr[p2];
            this.m_zptr[p2] = temp;
            ++p1;
            ++p2;
            --n;
        }
    }

    private void writeRun() throws IOException {
        if (this.m_last < this.m_allowableBlockSize) {
            this.m_inUse[this.m_currentChar] = true;
            int i = 0;
            while (i < this.m_runLength) {
                this.m_crc.updateCRC((char)this.m_currentChar);
                ++i;
            }
            switch (this.m_runLength) {
                case 1: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 2: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                case 3: {
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    break;
                }
                default: {
                    this.m_inUse[this.m_runLength - 4] = true;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)this.m_currentChar;
                    ++this.m_last;
                    this.m_block[this.m_last + 1] = (char)(this.m_runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    private static class StackElem {
        int m_dd;
        int m_hh;
        int m_ll;

        StackElem() {
        }
    }
}

