/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupEnumeration;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Wildcard;

public final class AttributeGroupDecl
extends AttributeGroup {
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$AttributeDecl == null ? (class$org$exolab$castor$xml$schema$AttributeDecl = AttributeGroupDecl.class$("org.exolab.castor.xml.schema.AttributeDecl")) : class$org$exolab$castor$xml$schema$AttributeDecl).getName();
    private String _name = null;
    private Schema _schema = null;
    private Vector _attributes = null;
    private Vector _references = null;
    private Wildcard _anyAttribute = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$AttributeDecl;

    public AttributeGroupDecl(Schema schema) {
        if (schema == null) {
            String string = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string);
        }
        this._schema = schema;
        this._attributes = new Vector();
        this._references = new Vector();
    }

    public void addAttribute(AttributeDecl attributeDecl) {
        if (attributeDecl == null) {
            return;
        }
        this._attributes.addElement(attributeDecl);
    }

    public void addReference(AttributeGroupReference attributeGroupReference) {
        if (attributeGroupReference == null) {
            return;
        }
        this._references.addElement(attributeGroupReference);
    }

    public Enumeration getMyAttributes() {
        return this._attributes.elements();
    }

    public Enumeration getMyAttributeGroupReferences() {
        return this._references.elements();
    }

    public Wildcard getAnyAttribute() {
        return this._anyAttribute;
    }

    public AttributeDecl getAttribute(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this._attributes.size()) {
            AttributeDecl attributeDecl = (AttributeDecl)this._attributes.elementAt(n);
            if (string.equals(attributeDecl.getName())) {
                return attributeDecl;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this._references.size()) {
            AttributeGroupReference attributeGroupReference = (AttributeGroupReference)this._references.elementAt(n2);
            AttributeDecl attributeDecl = attributeGroupReference.getAttribute(string);
            if (attributeDecl != null) {
                return attributeDecl;
            }
            ++n2;
        }
        return null;
    }

    public Enumeration getAttributes() {
        return new AttributeGroupEnumeration(this._attributes, this._references);
    }

    public String getName() {
        return this._name;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public boolean isEmpty() {
        if (this._attributes.size() > 0) {
            return false;
        }
        if (this._references.size() == 0) {
            return true;
        }
        int n = 0;
        while (n < this._references.size()) {
            if (!((AttributeGroup)this._references.elementAt(n)).isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean removeAttribute(AttributeDecl attributeDecl) {
        if (attributeDecl == null) {
            return false;
        }
        if (this._attributes.contains(attributeDecl)) {
            this._attributes.removeElement(attributeDecl);
            return true;
        }
        return false;
    }

    public boolean removeReference(AttributeGroupReference attributeGroupReference) {
        if (attributeGroupReference == null) {
            return false;
        }
        if (this._references.contains(attributeGroupReference)) {
            this._references.removeElement(attributeGroupReference);
            return true;
        }
        return false;
    }

    public void setAnyAttribute(Wildcard wildcard) throws SchemaException {
        if (wildcard != null) {
            if (this._anyAttribute != null) {
                String string = "<anyAttribute> already set in this AttributeGroup: " + this.getName();
                throw new SchemaException(string);
            }
            if (!wildcard.isAttributeWildcard()) {
                String string = "In AttributeGroup, " + this.getName() + "the wildcard must be an <anyAttribute>";
                throw new SchemaException(string);
            }
        }
        this._anyAttribute = wildcard;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        int n = string.indexOf(58);
        this._name = n >= 0 ? string.substring(n + 1) : string;
    }

    public short getStructureType() {
        return 4;
    }

    public void validate() throws ValidationException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

