/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.TypeReference;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.validators.ValidationUtils;

public class ElementDecl
extends Particle
implements Referable {
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + (class$org$exolab$castor$xml$schema$ElementDecl == null ? (class$org$exolab$castor$xml$schema$ElementDecl = ElementDecl.class$("org.exolab.castor.xml.schema.ElementDecl")) : class$org$exolab$castor$xml$schema$ElementDecl).getName();
    private BlockList _block = null;
    private Vector _constraints = null;
    private String _default = null;
    private String _elementRef = null;
    private FinalList _final = null;
    private String _fixed = null;
    private Form _form = null;
    private String _id = null;
    private boolean _isAbstract = false;
    private String _name = null;
    private boolean _nillable = false;
    private Schema _schema = null;
    private String _substitutionGroup = null;
    private XMLType _xmlType = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$ElementDecl;

    public ElementDecl(Schema schema) {
        this(schema, null);
    }

    public ElementDecl(Schema schema, String string) {
        super(1, 1);
        if (schema == null) {
            String string2 = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._schema = schema;
        this._constraints = new Vector(3);
        this.setName(string);
    }

    public void addIdentityConstraint(IdentityConstraint identityConstraint) {
        if (identityConstraint == null) {
            return;
        }
        this._constraints.addElement(identityConstraint);
    }

    public BlockList getBlock() {
        return this._block;
    }

    public String getDefaultValue() {
        return this._default;
    }

    public FinalList getFinal() {
        return this._final;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public Form getForm() {
        return this._form;
    }

    public String getId() {
        return this._id;
    }

    public Enumeration getIdentityConstraints() {
        return this._constraints.elements();
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (this.isReference() && !bl) {
            String string = this._elementRef;
            int n = string.indexOf(58);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        return this._name;
    }

    public XMLType getType() {
        if (this.isReference()) {
            ElementDecl elementDecl = this.getReference();
            if (elementDecl != null) {
                return elementDecl.getType();
            }
            return null;
        }
        if (this._xmlType == null) {
            return null;
        }
        return this._xmlType.getType();
    }

    public ElementDecl getReference() {
        if (this._elementRef != null) {
            return this._schema.getElementDecl(this._elementRef);
        }
        return null;
    }

    public String getReferenceId() {
        if (this._name != null) {
            return "element:" + this._name;
        }
        return null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getSubstitutionGroup() {
        return this._substitutionGroup;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean isReference() {
        return this._elementRef != null;
    }

    public void setAbstract(boolean bl) {
        this._isAbstract = bl;
    }

    public boolean hasChildren() {
        XMLType xMLType = this.getType();
        if (xMLType instanceof SimpleType) {
            return false;
        }
        if (xMLType instanceof ComplexType) {
            if (((ComplexType)xMLType).isComplexContent()) {
                return true;
            }
            if (((ComplexType)xMLType).getParticleCount() != 0) {
                return true;
            }
            Enumeration enumeration = ((ComplexType)xMLType).getAttributeDecls();
            return enumeration.hasMoreElements();
        }
        return false;
    }

    public boolean removeIdentityConstraint(IdentityConstraint identityConstraint) {
        if (identityConstraint == null) {
            return false;
        }
        return this._constraints.removeElement(identityConstraint);
    }

    public void setBlock(BlockList blockList) {
        this._block = blockList;
    }

    public void setBlock(String string) {
        this._block = string == null ? null : new BlockList(string);
    }

    public void setDefaultValue(String string) {
        this._default = string;
    }

    public void setFinal(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinal(String string) {
        this._final = string == null ? null : new FinalList(string);
    }

    public void setFixedValue(String string) {
        this._fixed = string;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setName(String string) {
        if (string != null && !ValidationUtils.isQName(string)) {
            String string2 = "error: '" + string + "' is not a valid QName.";
            throw new IllegalArgumentException(string2);
        }
        this._name = string;
    }

    public void setNillable(boolean bl) {
        this._nillable = bl;
    }

    public void setReference(ElementDecl elementDecl) {
        this._elementRef = elementDecl == null ? null : elementDecl.getName();
    }

    public void setReference(String string) {
        this._elementRef = string;
    }

    public void setSubstitutionGroup(String string) {
        this._substitutionGroup = string;
    }

    public void setType(XMLType xMLType) {
        if (this._xmlType != null) {
            this._xmlType.setParent(null);
        }
        if (xMLType != null) {
            xMLType.setParent(this);
        }
        this._xmlType = xMLType;
    }

    public void setTypeReference(String string) {
        TypeReference typeReference = new TypeReference();
        typeReference.setName(string);
        typeReference.setSchema(this._schema);
        this.setType(typeReference);
    }

    public short getStructureType() {
        return 8;
    }

    public void validate() throws ValidationException {
        if (this._elementRef != null) {
            if (this._schema.getElementDecl(this._elementRef) == null) {
                String string = "<element ref=\"" + this._elementRef + "\"> " + "is not resolvable.";
                throw new ValidationException(string);
            }
            return;
        }
        if (this._name == null) {
            String string = "<element> is missing required 'name' or 'ref' attribute.";
            throw new ValidationException(string);
        }
        XMLType xMLType = this.getType();
        if (xMLType != null) {
            SimpleType simpleType;
            if (xMLType.isComplexType()) {
                ComplexType complexType = (ComplexType)xMLType;
                if (!complexType.isTopLevel()) {
                    complexType.validate();
                }
            } else if (xMLType.isSimpleType() && (simpleType = (SimpleType)xMLType).getParent() != simpleType.getSchema()) {
                simpleType.validate();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

