/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.Enumeration;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ImportUnmarshaller;
import org.exolab.castor.xml.schema.reader.IncludeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnknownUnmarshaller;

public class SchemaUnmarshaller
extends ComponentReader {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String[] UNSUPPORTED_NAMESPACES = new String[]{"http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XML_PREFIX = "xml";
    private boolean _include = false;
    private ComponentReader unmarshaller;
    private int _annotationDepth = 0;
    private int depth = 0;
    boolean skipAll = false;
    Resolver _resolver = null;
    Schema _schema = new Schema();
    private boolean foundSchemaDef = false;
    private String defaultNS = null;
    private SchemaUnmarshallerState _state = null;

    public SchemaUnmarshaller() throws XMLException {
        this(null, null);
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(SchemaUnmarshallerState schemaUnmarshallerState) throws XMLException {
        this(null, null);
        this._state = schemaUnmarshallerState;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(boolean bl, SchemaUnmarshallerState schemaUnmarshallerState) throws XMLException {
        this();
        this._state = schemaUnmarshallerState;
        this._include = bl;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(AttributeSet attributeSet, Resolver resolver) throws XMLException {
        this.setResolver(resolver);
        this.foundSchemaDef = true;
        this._state = new SchemaUnmarshallerState();
        this.init(attributeSet);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Object getObject() {
        return this.getSchema();
    }

    public String elementName() {
        return "schema";
    }

    private void init(AttributeSet attributeSet) throws XMLException {
        if (attributeSet == null) {
            return;
        }
        String string = null;
        String string2 = attributeSet.getValue("targetNamespace");
        if (string2 != null && string2.length() == 0) {
            throw new SchemaException("empty string is not a legal namespace.");
        }
        if (string2 != null && string2.length() > 0) {
            if (this._include && !this._schema.getTargetNamespace().equals(string2)) {
                throw new SchemaException("The target namespace of the included components must be the same as the target namespace of the including schema");
            }
            this._schema.setTargetNamespace(string2);
        }
        this._schema.setId(attributeSet.getValue("id"));
        this._schema.setVersion(attributeSet.getValue("version"));
        this._schema.setSchemaLocation(this.getDocumentLocator().getSystemId());
        String string3 = attributeSet.getValue("attributeFormDefault");
        if (string3 != null) {
            this._schema.setAttributeFormDefault(Form.valueOf(string3));
        }
        if ((string3 = attributeSet.getValue("elementFormDefault")) != null) {
            this._schema.setElementFormDefault(Form.valueOf(string3));
        }
        if ((string = attributeSet.getValue("blockDefault")) != null) {
            this._schema.setBlockDefault(string);
        }
        if ((string = attributeSet.getValue("finalDefault")) != null) {
            this._schema.setFinalDefault(string);
        }
        if ((string = attributeSet.getValue("version")) != null) {
            this._schema.setVersion(string);
        }
    }

    private void handleNamespaces(Namespaces namespaces) throws XMLException {
        if (namespaces == null) {
            return;
        }
        Enumeration enumeration = namespaces.getLocalNamespaces();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = namespaces.getNamespacePrefix(string);
            if (string2 == null) {
                String string3 = "unexpected error processing the following namespace: '" + string + "'; the prefix could not be resolved.";
                throw new XMLException(string3);
            }
            if (string2.length() == 0) {
                this.defaultNS = string;
                this._schema.addNamespace("", this.defaultNS);
                continue;
            }
            int n = 0;
            while (n < UNSUPPORTED_NAMESPACES.length) {
                if (string.equals(UNSUPPORTED_NAMESPACES[n])) {
                    this.error("The following namespace \"" + string + "\" is no longer supported. Please update to " + " the W3C XML Schema Recommendation.");
                }
                ++n;
            }
            this._schema.addNamespace(string2, string);
        }
    }

    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            resolver = new ScopableResolver();
        }
        super.setResolver(resolver);
        this._resolver = resolver;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.skipAll) {
            return;
        }
        this.handleNamespaces(namespaces);
        if (!this.foundSchemaDef && string2 == null && this.defaultNS == null) {
            this.defaultNS = XSD_NAMESPACE;
            string2 = XSD_NAMESPACE;
            System.out.println("No namespace declaration has been found for " + string);
            System.out.print("   * assuming default namespace of ");
            System.out.println(XSD_NAMESPACE);
        }
        if (string2 == null) {
            string2 = this.defaultNS;
        }
        if (string.equals("annotation")) {
            ++this._annotationDepth;
        }
        if (!XSD_NAMESPACE.equals(string2) && this._annotationDepth == 0) {
            this.error("'" + string + "' has not been declared in the XML " + "Schema namespace.");
        }
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if (string.equals("schema")) {
            if (this.foundSchemaDef) {
                this.illegalElement(string);
            }
            this.foundSchemaDef = true;
            this.init(attributeSet);
            return;
        }
        if (string.equals("annotation")) {
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if (string.equals("attribute")) {
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if (string.equals("attributeGroup")) {
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeSet);
        } else if (string.equals("complexType")) {
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, attributeSet, this._resolver);
        } else if (string.equals("element")) {
            this.unmarshaller = new ElementUnmarshaller(this._schema, attributeSet, this._resolver);
        } else if (string.equals("simpleType")) {
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeSet);
        } else if (string.equals("group")) {
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeSet, this._resolver);
        } else if (string.equals("include")) {
            this.unmarshaller = new IncludeUnmarshaller(this._schema, attributeSet, this._resolver, this.getDocumentLocator(), this._state);
        } else if (string.equals("import")) {
            this.unmarshaller = new ImportUnmarshaller(this._schema, attributeSet, this._resolver, this.getDocumentLocator(), this._state);
        } else {
            System.out.print('<');
            System.out.print(string);
            System.out.print("> elements are either currently unsupported ");
            System.out.println("or non-valid schema elements.");
            this.unmarshaller = new UnknownUnmarshaller(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.skipAll) {
            return;
        }
        if (string2 == null) {
            string2 = this.defaultNS;
        }
        if (string.equals("annotation")) {
            --this._annotationDepth;
        }
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if ((string = string.intern()) == "schema") {
            return;
        }
        if (this.unmarshaller != null) {
            if (!string.equals(this.unmarshaller.elementName())) {
                String string3 = "error: missing end element for ";
                string3 = string3 + this.unmarshaller.elementName();
                throw new SchemaException(string3);
            }
        } else {
            String string4 = "error: missing start element for " + string;
            throw new SchemaException(string4);
        }
        this.unmarshaller.finish();
        if (string.equals("annotation")) {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        } else if (string.equals("attribute")) {
            this._schema.addAttribute((AttributeDecl)this.unmarshaller.getObject());
        } else if (string.equals("attributeGroup")) {
            Object object = this.unmarshaller.getObject();
            try {
                this._schema.addAttributeGroup((AttributeGroupDecl)object);
            }
            catch (ClassCastException classCastException) {
                String string5 = "Top-level AttributeGroups must be defining AttributeGroups and not referring AttributeGroups.";
                this.error(string5);
            }
        } else if (string.equals("complexType")) {
            ComplexType complexType = null;
            complexType = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._schema.addComplexType(complexType);
            if (complexType.getName() != null) {
                this._resolver.addResolvable(complexType.getReferenceId(), complexType);
            } else {
                System.out.println("warning: top-level complexType with no name.");
            }
        } else if (string.equals("simpleType")) {
            SimpleType simpleType = null;
            simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._schema.addSimpleType(simpleType);
            this._resolver.addResolvable(simpleType.getReferenceId(), simpleType);
        } else if (string.equals("element")) {
            ElementDecl elementDecl = null;
            elementDecl = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._schema.addElementDecl(elementDecl);
        } else if (string.equals("group")) {
            ModelGroup modelGroup = null;
            modelGroup = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._schema.addModelGroup(modelGroup);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

