/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.jdbc.support.SQLErrorCodesFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLErrorCodeSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected SQLErrorCodes sqlErrorCodes;
    private SQLExceptionTranslator fallback = new SQLStateSQLExceptionTranslator();

    public SQLErrorCodeSQLExceptionTranslator() {
    }

    public SQLErrorCodeSQLExceptionTranslator(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public SQLErrorCodeSQLExceptionTranslator(DataSource ds) {
        this.setDataSource(ds);
    }

    public void setDataSource(DataSource ds) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(ds);
    }

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallback = fallback;
    }

    public void setSqlErrorCodes(SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    public DataAccessException translate(String task, String sql, SQLException sqlex) {
        DataAccessException dex = this.customTranslate(task, sql, sqlex);
        if (dex != null) {
            return dex;
        }
        String errorCode = this.sqlErrorCodes.isUseSqlStateForTranslation() ? sqlex.getSQLState() : Integer.toString(sqlex.getErrorCode());
        if (errorCode != null) {
            if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex);
                return new BadSqlGrammarException(task, sql, sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex);
                return new DataIntegrityViolationException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataRetrievalFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex);
                return new DataRetrievalFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getOptimisticLockingFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex);
                return new OptimisticLockingFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), errorCode) >= 0) {
                this.logTranslation(task, sql, sqlex);
                return new DataAccessResourceFailureException(task + ": " + sqlex.getMessage(), sqlex);
            }
        }
        this.logger.warn((Object)("Unable to translate SQLException with errorCode '" + sqlex.getErrorCode() + "', will now try the fallback translator"));
        return this.fallback.translate(task, sql, sqlex);
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlex) {
        return null;
    }

    private void logTranslation(String task, String sql, SQLException sqlex) {
        this.logger.warn((Object)("Translating SQLException with SQLState '" + sqlex.getSQLState() + "' and errorCode '" + sqlex.getErrorCode() + "' and message [" + sqlex.getMessage() + "]; SQL was [" + sql + "] for task [" + task + "]"));
    }
}

