/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.AbstractCollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.BatchingCollectionInitializer;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.CollectionLoader;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.sql.Delete;
import net.sf.hibernate.sql.Insert;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.util.ArrayHelper;

public final class BasicCollectionPersister
extends AbstractCollectionPersister {
    public BasicCollectionPersister(Collection collection, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cfg, factory);
    }

    protected String generateDeleteString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        return delete.toStatementString();
    }

    protected String generateInsertRowString() {
        Insert insert = new Insert(null).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames);
        }
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        return insert.addColumns(this.elementColumnNames).toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.elementColumnNames);
        if (this.hasIdentifier) {
            update.setPrimaryKeyColumnNames(this.rowSelectColumnNames);
        } else {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames));
        }
        return update.toStatementString();
    }

    protected String generateDeleteRowString() {
        String[] pkColumns = this.hasIdentifier ? this.rowSelectColumnNames : ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames);
        return new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(pkColumns).toStatementString();
    }

    public boolean consumesAlias() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        try {
            PreparedStatement st = null;
            Iterator entries = collection.entries();
            try {
                int i = 0;
                int count = 0;
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLUpdateRowString());
                        }
                        if (!this.hasIdentifier) {
                            this.writeKey(st, id, true, session);
                        }
                        collection.writeTo(st, this, entry, i, true);
                        session.getBatcher().addToBatch(1);
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not update collection rows: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    public String selectFragment(String alias, String suffix) {
        return this.selectClauseFragment(alias);
    }

    protected CollectionInitializer createCollectionInitializer(SessionFactoryImplementor factory) throws MappingException {
        CollectionLoader nonbatchLoader = new CollectionLoader(this, factory);
        if (this.batchSize > 1) {
            CollectionLoader batchLoader = new CollectionLoader(this, this.batchSize, factory);
            int smallBatchSize = (int)Math.round(Math.sqrt(this.batchSize));
            CollectionLoader smallBatchLoader = new CollectionLoader(this, smallBatchSize, factory);
            return new BatchingCollectionInitializer(this, this.batchSize, batchLoader, smallBatchSize, smallBatchLoader, nonbatchLoader);
        }
        return nonbatchLoader;
    }
}

