/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DBCPConnectionProvider
implements ConnectionProvider {
    private Integer isolation;
    private DataSource ds;
    private KeyedObjectPoolFactory statementPool;
    private ObjectPool connectionPool;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$DBCPConnectionProvider == null ? (class$net$sf$hibernate$connection$DBCPConnectionProvider = DBCPConnectionProvider.class$("net.sf.hibernate.connection.DBCPConnectionProvider")) : class$net$sf$hibernate$connection$DBCPConnectionProvider));
    static /* synthetic */ Class class$net$sf$hibernate$connection$DBCPConnectionProvider;

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit()) {
            c.setAutoCommit(false);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
        log.info((Object)("DBCP using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + connectionProps));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
        }
        try {
            this.connectionPool = new GenericObjectPool(null, Integer.parseInt(props.getProperty("hibernate.dbcp.maxActive")), Byte.parseByte(props.getProperty("hibernate.dbcp.whenExhaustedAction")), Long.parseLong(props.getProperty("hibernate.dbcp.maxWait")), Integer.parseInt(props.getProperty("hibernate.dbcp.maxIdle")), PropertiesHelper.getBoolean("hibernate.dbcp.testOnBorrow", props), PropertiesHelper.getBoolean("hibernate.dbcp.testOnReturn", props));
            this.statementPool = new GenericKeyedObjectPoolFactory(null, Integer.parseInt(props.getProperty("hibernate.dbcp.ps.maxActive")), Byte.parseByte(props.getProperty("hibernate.dbcp.ps.whenExhaustedAction")), Long.parseLong(props.getProperty("hibernate.dbcp.ps.maxWait")), Integer.parseInt(props.getProperty("hibernate.dbcp.ps.maxIdle")));
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcUrl, connectionProps);
            String validationQuery = props.getProperty("hibernate.dbcp.validationQuery");
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, this.statementPool, validationQuery, false, false);
            this.ds = new PoolingDataSource(this.connectionPool);
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate DBCP connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate DBCP connection pool", e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    public void close() throws HibernateException {
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            throw new HibernateException("could not close DBCP pool", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

