/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.util.StringHelper;

public abstract class Junction
extends AbstractCriterion {
    private List criteria = new ArrayList();

    public Junction add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    abstract String getOp();

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        ArrayList<TypedValue> typedValues = new ArrayList<TypedValue>();
        Iterator iter = this.criteria.iterator();
        while (iter.hasNext()) {
            TypedValue[] subvalues = ((Criterion)iter.next()).getTypedValues(sessionFactory, persistentClass, aliasClasses);
            for (int i = 0; i < subvalues.length; ++i) {
                typedValues.add(subvalues[i]);
            }
        }
        return typedValues.toArray(new TypedValue[typedValues.size()]);
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        if (this.criteria.size() == 0) {
            return "1=1";
        }
        StringBuffer buffer = new StringBuffer().append('(');
        Iterator iter = this.criteria.iterator();
        while (iter.hasNext()) {
            buffer.append(((Criterion)iter.next()).toSqlString(sessionFactory, persistentClass, alias, aliasClasses));
            if (!iter.hasNext()) continue;
            buffer.append(this.getOp());
        }
        return buffer.append(')').toString();
    }

    public String toString() {
        return '(' + StringHelper.join(this.getOp(), this.criteria.iterator()) + ')';
    }
}

