/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type type;
    private String sql;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$id$SequenceGenerator == null ? (class$net$sf$hibernate$id$SequenceGenerator = SequenceGenerator.class$("net.sf.hibernate.id.SequenceGenerator")) : class$net$sf$hibernate$id$SequenceGenerator));
    static /* synthetic */ Class class$net$sf$hibernate$id$SequenceGenerator;

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString(SEQUENCE, params, "hibernate_sequence");
        this.parameters = params.getProperty(PARAMETERS);
        String schemaName = params.getProperty("schema");
        if (schemaName != null && this.sequenceName.indexOf(46) < 0) {
            this.sequenceName = schemaName + '.' + this.sequenceName;
        }
        this.type = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        PreparedStatement st = session.getBatcher().prepareStatement(this.sql);
        try {
            Serializable result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = IdentifierGeneratorFactory.get(rs, this.type, session, obj);
            }
            finally {
                rs.close();
            }
            log.debug((Object)("Sequence identifier generated: " + result));
            Serializable serializable = result;
            return serializable;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        finally {
            session.getBatcher().closeStatement(st);
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String ddl = dialect.getCreateSequenceString(this.sequenceName);
        if (this.parameters != null) {
            ddl = ddl + ' ' + this.parameters;
        }
        return new String[]{ddl};
    }

    public String sqlDropString(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceString(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

