/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jca;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.jca.JCASessionFactoryImpl;
import net.sf.hibernate.jca.ManagedConnectionImpl;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$jca$ManagedConnectionFactoryImpl == null ? (class$net$sf$hibernate$jca$ManagedConnectionFactoryImpl = ManagedConnectionFactoryImpl.class$("net.sf.hibernate.jca.ManagedConnectionFactoryImpl")) : class$net$sf$hibernate$jca$ManagedConnectionFactoryImpl));
    private String dialect;
    private String mapResources;
    private String datasourceJndi;
    private String properties;
    private PrintWriter out;
    private DataSource datasource;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$net$sf$hibernate$jca$ManagedConnectionFactoryImpl;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.log("createConnectionFactory with connection manager - " + cxManager);
        this.initialize();
        JCASessionFactoryImpl obj = null;
        try {
            obj = new JCASessionFactoryImpl(this, cxManager);
        }
        catch (HibernateException hbe) {
            String message = "Got Hibernate exception when trying to create Connection Factory";
            this.log("Got Hibernate exception when trying to create Connection Factory", hbe);
            ResourceException re = new ResourceException("Got Hibernate exception when trying to create Connection Factory");
            re.setLinkedException((Exception)hbe);
            throw re;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() throws ResourceException {
        if (this.datasource == null) {
            try {
                InitialContext ctx = new InitialContext();
                try {
                    this.datasource = (DataSource)ctx.lookup(this.datasourceJndi);
                }
                finally {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                String message = "Cannot locate DataSource " + this.datasourceJndi;
                this.log(message, e);
                ResourceException re = new ResourceException(message);
                re.setLinkedException((Exception)e);
                throw re;
            }
        }
        if (this.sessionFactory == null) {
            try {
                String delim = " ,\n\t\r\f";
                Properties hibProperties = new Properties();
                hibProperties.setProperty("hibernate.dialect", this.dialect);
                hibProperties.setProperty("hibernate.connection.datasource", this.datasourceJndi);
                Configuration cfg = new Configuration().addProperties(hibProperties);
                String[] mappingFiles = PropertiesHelper.toStringArray(this.mapResources, " ,\n\t\r\f");
                for (int i = 0; i < mappingFiles.length; ++i) {
                    cfg.addResource(mappingFiles[i], Thread.currentThread().getContextClassLoader());
                }
                this.sessionFactory = cfg.buildSessionFactory();
            }
            catch (HibernateException e) {
                String message = "Cannot create Hibernate session factory";
                this.log("Cannot create Hibernate session factory", e);
                ResourceException re = new ResourceException("Cannot create Hibernate session factory");
                re.setLinkedException((Exception)e);
                throw re;
            }
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("Resource Adapter does not support an un-managed environment");
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) {
        this.log("createManagedConnection called");
        return new ManagedConnectionImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Iterator i = mcs.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ManagedConnectionImpl)) continue;
            return (ManagedConnectionImpl)o;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.datasourceJndi == null ? 0 : this.datasourceJndi.hashCode());
        result = result * 37 + (this.dialect == null ? 0 : this.dialect.hashCode());
        result = result * 37 + (this.mapResources == null ? 0 : this.mapResources.hashCode());
        result = result * 37 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean result = false;
        if (object instanceof ManagedConnectionFactoryImpl) {
            ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)object;
            result = this.equals(this.datasourceJndi, other.datasourceJndi) && this.equals(this.dialect, other.dialect) && this.equals(this.mapResources, other.mapResources) && this.equals(this.properties, other.properties);
        }
        return result;
    }

    public void setDatasourceJndi(String datasourceJndi) {
        this.datasourceJndi = datasourceJndi;
    }

    public String getDatasourceJndi() {
        return this.datasourceJndi;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getMapResources() {
        return this.mapResources;
    }

    public void setMapResources(String mapResources) {
        this.mapResources = mapResources;
    }

    public String getHibernateProperties() {
        return this.properties;
    }

    public void setHibernateProperties(String properties) {
        this.properties = properties;
    }

    DataSource getDatasource() {
        return this.datasource;
    }

    SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        if (this.out != null) {
            this.out.write(message);
            if (t != null) {
                t.printStackTrace(this.out);
            }
        }
        if (t != null) {
            log.error((Object)message, t);
        } else {
            log.info((Object)message);
        }
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

