/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.Formula;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;

public class SimpleValue
implements Value {
    private final List columns = new ArrayList();
    private Type type;
    private Properties identifierGeneratorProperties;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private Table table;
    private Formula formula;
    private String foreignKeyName;
    private boolean unique;
    private IdentifierGenerator uniqueIdentifierGenerator;

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public List getConstraintColumns() {
        return this.columns;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        Iterator iter = this.getColumnIterator();
        int count = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            col.setType(type);
            col.setTypeIndex(count++);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public SimpleValue(Table table) {
        this.table = table;
    }

    public void createForeignKey() {
    }

    public void createForeignKeyOfClass(Class persistentClass) {
        this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), persistentClass);
    }

    public IdentifierGenerator createIdentifierGenerator(Dialect dialect) throws MappingException {
        if (this.uniqueIdentifierGenerator == null) {
            this.uniqueIdentifierGenerator = IdentifierGeneratorFactory.create(this.identifierGeneratorStrategy, this.type, this.identifierGeneratorProperties, dialect);
        }
        return this.uniqueIdentifierGenerator;
    }

    public int getOuterJoinFetchSetting() {
        return -1;
    }

    public Properties getIdentifierGeneratorProperties() {
        return this.identifierGeneratorProperties;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Table getTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    public void setIdentifierGeneratorProperties(Properties identifierGeneratorProperties) {
        this.identifierGeneratorProperties = identifierGeneratorProperties;
    }

    public void setIdentifierGeneratorStrategy(String identifierGeneratorStrategy) {
        this.identifierGeneratorStrategy = identifierGeneratorStrategy;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String string) {
        this.foreignKeyName = string;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isNullable() {
        boolean nullable = true;
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            if (((Column)iter.next()).isNullable()) continue;
            nullable = false;
        }
        return nullable;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.type == null) {
                this.type = ReflectHelper.reflectedPropertyType(propertyClass, propertyName);
                Iterator iter = this.getColumnIterator();
                int count = 0;
                while (iter.hasNext()) {
                    Column col = (Column)iter.next();
                    col.setType(this.type);
                    col.setTypeIndex(count++);
                }
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set property type by reflection", he);
        }
    }

    public boolean isSimpleValue() {
        return true;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mapping);
    }
}

