/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class CJKTokenizer
extends Tokenizer {
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 256;
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[256];
    private String tokenType = "word";
    private boolean preIsTokened = false;

    public CJKTokenizer(Reader reader) {
        this.input = reader;
    }

    public final Token next() throws IOException {
        int n = 0;
        int n2 = this.offset;
        while (true) {
            char c;
            Character.UnicodeBlock unicodeBlock;
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                if (n > 0) {
                    if (!this.preIsTokened) break;
                    n = 0;
                    this.preIsTokened = false;
                    break;
                }
                return null;
            }
            if ((unicodeBlock = Character.UnicodeBlock.of(c = this.ioBuffer[this.bufferIndex++])) == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                if (unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                    char c2 = c;
                    c = c2 -= 65248;
                }
                if (Character.isLetterOrDigit(c) || c == '_' || c == '+' || c == '#') {
                    if (n == 0) {
                        n2 = this.offset - 1;
                    } else if (this.tokenType == "double") {
                        --this.offset;
                        --this.bufferIndex;
                        this.tokenType = "single";
                        if (!this.preIsTokened) break;
                        n = 0;
                        this.preIsTokened = false;
                        break;
                    }
                    this.buffer[n++] = Character.toLowerCase(c);
                    this.tokenType = "single";
                    if (n != 255) continue;
                    break;
                }
                if (n <= 0) continue;
                if (!this.preIsTokened) break;
                n = 0;
                this.preIsTokened = false;
                continue;
            }
            if (Character.isLetter(c)) {
                if (n == 0) {
                    n2 = this.offset - 1;
                    this.buffer[n++] = c;
                    this.tokenType = "double";
                    continue;
                }
                if (this.tokenType == "single") {
                    --this.offset;
                    --this.bufferIndex;
                    break;
                }
                this.buffer[n++] = c;
                this.tokenType = "double";
                if (n != 2) continue;
                --this.offset;
                --this.bufferIndex;
                this.preIsTokened = true;
                break;
            }
            if (n <= 0) continue;
            if (!this.preIsTokened) break;
            n = 0;
            this.preIsTokened = false;
        }
        return new Token(new String(this.buffer, 0, n), n2, n2 + n, this.tokenType);
    }
}

