/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class NormalizeReader
extends FilterReader {
    public static final int[] CONVERSION_TABLE = new int[]{-1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 43, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, -1, -1, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533};

    public NormalizeReader(Reader reader) {
        super(reader);
        this.in = reader;
    }

    public int read() throws IOException {
        return this.convert((char)this.in.read());
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.in.read(cArray, n, n2);
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = this.convert(cArray[i]);
        }
        return n3;
    }

    char convert(char c) {
        if (c >= '\uff01' && c <= '\uff5e' || c >= '\uff61' && c <= '\uff9f') {
            c = (char)CONVERSION_TABLE[c - 65280];
        }
        return c;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

