/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.chasen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import org.apache.lucene.analysis.ja.chasen.ChasenConnector;

public class NetworkConnector
extends ChasenConnector {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 31000;
    public static final String DEFAULT_CHARSET = "EUC-JP";
    public static final String RUN_COMMAND = "RUN";
    public static final String RC_COMMAND = "RC";
    public static final String HELP_COMMAND = "HELP";
    public static final String QUIT_COMMAND = "QUIT";
    private String hostname = System.getProperty("chasen.host", "localhost");
    private int port;
    private String charset = "EUC-JP";
    private BufferedReader in;
    private PrintWriter out;
    private boolean needCheck = false;

    public NetworkConnector() {
        String string = System.getProperty("chasen.port");
        this.port = string == null ? 31000 : Integer.parseInt(string);
    }

    public void open() throws IOException {
        Socket socket = new Socket(this.hostname, this.port);
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.charset));
        this.out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), this.charset));
        this.checkStatus();
        this.out.print("RUN\r\n");
        this.out.flush();
        this.needCheck = true;
    }

    public String readLine() throws IOException {
        String string;
        if (this.needCheck) {
            this.checkStatus();
            this.needCheck = false;
        }
        if ((string = this.in.readLine()).equals(".")) {
            return null;
        }
        if (string.length() > 1 && string.charAt(0) == '.') {
            string = string.substring(1);
        }
        return string;
    }

    public void println(String string) throws IOException {
        if (string.length() > 0 && string.charAt(0) == '.') {
            this.out.print('.');
        }
        this.out.print(string);
        this.out.print("\r\n");
        this.out.flush();
    }

    void checkStatus() throws IOException {
        String string = this.in.readLine();
        if (!string.startsWith("200 ")) {
            throw new IllegalStateException("Illegal return code: " + string);
        }
    }

    public void quit() {
        this.out.print(".\r\n");
        this.out.print("QUIT\r\n");
        this.out.flush();
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }
}

