/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CharsetDetector {
    static String JIS = "ISO-2022-JP";
    static String SJIS = "Shift_JIS";
    static String EUCJP = "EUC_JP";
    static String ASCII = "ISO-8859-1";
    static String unknown = SJIS;
    static int BUFFER_SIZE = 10000;
    private InputStream in = null;
    private boolean prefetchFlag = false;
    private int prefetchChar;
    private int length = 0;
    private int cnt = 0;

    CharsetDetector(String string) throws IOException {
        File file = new File(string);
        this.length = (int)file.length();
        this.in = new BufferedInputStream(new FileInputStream(file), BUFFER_SIZE);
    }

    CharsetDetector(InputStream inputStream) throws IOException {
        this.length = inputStream.available();
        this.in = new BufferedInputStream(inputStream, BUFFER_SIZE);
    }

    CharsetDetector(File file) throws IOException {
        this.length = (int)file.length();
        this.in = new BufferedInputStream(new FileInputStream(file), BUFFER_SIZE);
    }

    public static void setUnknownCharset(String string) {
        unknown = string;
    }

    int nextChar() throws IOException {
        if (this.cnt == this.length) {
            return -1;
        }
        ++this.cnt;
        try {
            if (!this.prefetchFlag) {
                int n = this.in.read();
                return n;
            }
            this.prefetchFlag = false;
            return this.prefetchChar;
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.toString());
        }
    }

    int prefetchChar() throws IOException {
        if (this.prefetchFlag) {
            return this.prefetchChar;
        }
        if (this.cnt == this.length) {
            return -1;
        }
        this.prefetchFlag = true;
        this.prefetchChar = this.in.read();
        return this.prefetchChar;
    }

    public String detect() throws IOException {
        int n;
        while ((n = this.prefetchChar()) != -1) {
            if (n < 128) {
                if (n == 27) {
                    return JIS;
                }
            } else if (n > 160 && n < 224) {
                return this.detectEUCSJIS();
            }
            n = this.nextChar();
        }
        return ASCII;
    }

    private static boolean isSJIS1(int n) {
        return n >= 129 && n <= 159;
    }

    private static boolean isSJIS2(int n) {
        return n >= 64 && n <= 126 || n >= 128 && n <= 160;
    }

    private static boolean isEUC1(int n) {
        return n >= 240 && n <= 254;
    }

    private static boolean isEUC2(int n) {
        return n >= 253 && n <= 254;
    }

    private static boolean isKana(int n) {
        return n >= 161 && n <= 223;
    }

    private static boolean isASCII(int n) {
        return n >= 0 && n <= 127;
    }

    private String detectEUCSJIS() throws IOException {
        int n;
        while ((n = this.nextChar()) != -1) {
            int n2;
            if (CharsetDetector.isASCII(n)) continue;
            if (CharsetDetector.isSJIS1(n)) {
                return SJIS;
            }
            if (CharsetDetector.isKana(n) && (CharsetDetector.isASCII(n2 = this.prefetchChar()) || n2 > 128 && n2 < 160)) {
                return SJIS;
            }
            if (CharsetDetector.isEUC1(n)) {
                return EUCJP;
            }
            n = this.nextChar();
            if (CharsetDetector.isSJIS2(n)) {
                return SJIS;
            }
            if (!CharsetDetector.isEUC2(n)) continue;
            return EUCJP;
        }
        return unknown;
    }

    public static void main(String[] stringArray) {
        try {
            CharsetDetector charsetDetector = new CharsetDetector(stringArray[0]);
            CharsetDetector.setUnknownCharset("EUC_JP");
            System.out.println(charsetDetector.detect());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

